/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.file.CloudFile;
import com.microsoft.azure.storage.file.CloudFileClient;
import com.microsoft.azure.storage.file.CloudFileDirectory;
import com.microsoft.azure.storage.file.CloudFileShare;
import com.microsoft.azure.storage.file.FileInputStream;
import com.microsoft.azure.storage.file.ListFileItem;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteInfo;
import org.apache.zeppelin.notebook.repo.NotebookRepo;
import org.apache.zeppelin.notebook.repo.NotebookRepoSettingsInfo;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureNotebookRepo
implements NotebookRepo {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureNotebookRepo.class);
    private ZeppelinConfiguration conf;
    private String user;
    private String shareName;
    private CloudFileDirectory rootDir;

    public void init(ZeppelinConfiguration conf) throws IOException {
        this.conf = conf;
        this.user = conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_AZURE_USER);
        this.shareName = conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_AZURE_SHARE);
        try {
            CloudStorageAccount account = CloudStorageAccount.parse((String)conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_AZURE_CONNECTION_STRING));
            CloudFileClient client = account.createCloudFileClient();
            CloudFileShare share = client.getShareReference(this.shareName);
            share.createIfNotExists();
            CloudFileDirectory userDir = StringUtils.isBlank((String)this.user) ? share.getRootDirectoryReference() : share.getRootDirectoryReference().getDirectoryReference(this.user);
            userDir.createIfNotExists();
            this.rootDir = userDir.getDirectoryReference("notebook");
            this.rootDir.createIfNotExists();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public Map<String, NoteInfo> list(AuthenticationInfo subject) throws IOException {
        return this.list(this.rootDir);
    }

    private Map<String, NoteInfo> list(CloudFileDirectory folder) throws IOException {
        HashMap<String, NoteInfo> notesInfo = new HashMap<String, NoteInfo>();
        for (ListFileItem item : this.rootDir.listFilesAndDirectories()) {
            if (item instanceof CloudFileDirectory) {
                CloudFileDirectory dir = (CloudFileDirectory)item;
                notesInfo.putAll(this.list(dir));
                continue;
            }
            if (!(item instanceof CloudFile)) continue;
            CloudFile file = (CloudFile)item;
            if (file.getName().endsWith(".zpln")) {
                try {
                    String noteName = this.getNotePath(this.rootDir.getUri().getPath(), file.getUri().getPath());
                    String noteId = this.getNoteId(file.getUri().getPath());
                    notesInfo.put(noteId, new NoteInfo(noteId, noteName));
                }
                catch (IOException e) {
                    LOGGER.warn(e.getMessage());
                }
                continue;
            }
            LOGGER.debug("Skip invalid note file: " + file.getUri().getPath());
        }
        return notesInfo;
    }

    public Note get(String noteId, String notePath, AuthenticationInfo subject) throws IOException {
        FileInputStream ins = null;
        try {
            CloudFile noteFile = this.rootDir.getFileReference(this.buildNoteFileName(noteId, notePath));
            ins = noteFile.openRead();
        }
        catch (StorageException | URISyntaxException e) {
            String msg = String.format("Error reading notebook %s from Azure storage", this.buildNoteFileName(noteId, notePath));
            LOGGER.error(msg, e);
            throw new IOException(msg, e);
        }
        String json = IOUtils.toString((InputStream)ins, (String)this.conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_ENCODING));
        ins.close();
        return Note.fromJson((String)json);
    }

    public void save(Note note, AuthenticationInfo subject) throws IOException {
        try {
            CloudFile noteFile = this.rootDir.getFileReference(this.buildNoteFileName(note));
            noteFile.getParent().createIfNotExists();
            noteFile.uploadText(note.toJson());
        }
        catch (StorageException | URISyntaxException e) {
            String msg = String.format("Error saving notebook %s to Azure storage", this.buildNoteFileName(note));
            LOGGER.error(msg, e);
            throw new IOException(msg, e);
        }
    }

    public void move(String noteId, String notePath, String newNotePath, AuthenticationInfo subject) {
    }

    public void move(String folderPath, String newFolderPath, AuthenticationInfo subject) {
    }

    public void remove(String noteId, String notePath, AuthenticationInfo subject) throws IOException {
        try {
            CloudFile noteFile = this.rootDir.getFileReference(this.buildNoteFileName(noteId, notePath));
            noteFile.delete();
        }
        catch (StorageException | URISyntaxException e) {
            String msg = String.format("Error deleting notebook %s from Azure storage", this.buildNoteFileName(noteId, notePath));
            LOGGER.error(msg, e);
            throw new IOException(msg, e);
        }
    }

    public void remove(String folderPath, AuthenticationInfo subject) {
    }

    public void close() {
    }

    public List<NotebookRepoSettingsInfo> getSettings(AuthenticationInfo subject) {
        LOGGER.warn("Method not implemented");
        return Collections.emptyList();
    }

    public void updateSettings(Map<String, String> settings, AuthenticationInfo subject) {
        LOGGER.warn("Method not implemented");
    }
}

