/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.flink.shims111;

import java.net.InetAddress;
import java.util.UUID;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.experimental.CollectSink;
import org.apache.flink.table.sinks.RetractStreamTableSink;
import org.apache.flink.types.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectStreamTableSink
implements RetractStreamTableSink<Row> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectStreamTableSink.class);
    private final InetAddress targetAddress;
    private final int targetPort;
    private final TypeSerializer<Tuple2<Boolean, Row>> serializer;
    private String[] fieldNames;
    private TypeInformation<?>[] fieldTypes;

    public CollectStreamTableSink(InetAddress targetAddress, int targetPort, TypeSerializer<Tuple2<Boolean, Row>> serializer) {
        LOGGER.info("Use address: " + targetAddress.getHostAddress() + ":" + targetPort);
        this.targetAddress = targetAddress;
        this.targetPort = targetPort;
        this.serializer = serializer;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public TypeInformation<?>[] getFieldTypes() {
        return this.fieldTypes;
    }

    public CollectStreamTableSink configure(String[] fieldNames, TypeInformation<?>[] fieldTypes) {
        CollectStreamTableSink copy = new CollectStreamTableSink(this.targetAddress, this.targetPort, this.serializer);
        copy.fieldNames = fieldNames;
        copy.fieldTypes = fieldTypes;
        return copy;
    }

    public TypeInformation<Row> getRecordType() {
        return Types.ROW_NAMED((String[])this.fieldNames, this.fieldTypes);
    }

    public DataStreamSink<?> consumeDataStream(DataStream<Tuple2<Boolean, Row>> stream) {
        return stream.addSink((SinkFunction)new CollectSink(this.targetAddress, this.targetPort, this.serializer)).name("Zeppelin Flink Sql Stream Collect Sink " + UUID.randomUUID()).setParallelism(1);
    }

    public TupleTypeInfo<Tuple2<Boolean, Row>> getOutputType() {
        return new TupleTypeInfo(new TypeInformation[]{Types.BOOLEAN, this.getRecordType()});
    }
}

