/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.flink;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkVersion {
    private static final Logger logger = LoggerFactory.getLogger(FlinkVersion.class);
    private int majorVersion;
    private int minorVersion;
    private int patchVersion;
    private int version;
    private String versionString;

    public FlinkVersion(String versionString) {
        this.versionString = versionString;
        try {
            int pos = versionString.indexOf(45);
            String numberPart = versionString;
            if (pos > 0) {
                numberPart = versionString.substring(0, pos);
            }
            String[] versions = numberPart.split("\\.");
            this.majorVersion = Integer.parseInt(versions[0]);
            this.minorVersion = Integer.parseInt(versions[1]);
            if (versions.length == 3) {
                this.patchVersion = Integer.parseInt(versions[2]);
            }
            this.version = Integer.parseInt(String.format("%d%02d%02d", this.majorVersion, this.minorVersion, this.patchVersion));
        }
        catch (Exception e) {
            logger.error("Can not recognize Flink version " + versionString + ". Assume it's a future release", (Throwable)e);
        }
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public boolean olderThan(FlinkVersion versionToCompare) {
        return this.version < versionToCompare.version;
    }

    public boolean newerThanOrEqual(FlinkVersion versionToCompare) {
        return this.version >= versionToCompare.version;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String toString() {
        return this.versionString;
    }

    public static FlinkVersion fromVersionString(String versionString) {
        return new FlinkVersion(versionString);
    }

    public boolean isAfterFlink114() {
        return this.newerThanOrEqual(FlinkVersion.fromVersionString("1.14.0"));
    }
}

