/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.spring.context;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.AbstractXmlApplicationContext;

public abstract class SpringTestSupport
extends TestCase {
    protected transient Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected AbstractXmlApplicationContext context;

    protected void setUp() throws Exception {
        this.context = this.createApplicationContext();
        Assert.assertNotNull((String)"ApplicationContext is null!", (Object)this.context);
    }

    protected void tearDown() throws Exception {
        if (this.context != null) {
            this.log.info((Object)"Closing down the spring context");
            this.context.destroy();
        }
    }

    protected Object getBean(String name) {
        Object answer = this.context.getBean(name);
        Assert.assertNotNull((String)("Could not find object in Spring for key: " + name), (Object)answer);
        return answer;
    }

    protected abstract AbstractXmlApplicationContext createApplicationContext();
}

