/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.spring.context;

import java.net.URI;
import java.util.List;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xbean.spring.context.ClassPathXmlApplicationContext;
import org.apache.xbean.spring.context.SpringTestSupport;
import org.apache.xbean.spring.context.impl.XBeanXmlBeanFactory;
import org.apache.xbean.spring.example.PizzaService;
import org.apache.xbean.spring.example.RestaurantService;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class RestaurantUsingXBeanTest
extends SpringTestSupport {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xbean$spring$context$RestaurantUsingXBeanTest == null ? (class$org$apache$xbean$spring$context$RestaurantUsingXBeanTest = RestaurantUsingXBeanTest.class$("org.apache.xbean.spring.context.RestaurantUsingXBeanTest")) : class$org$apache$xbean$spring$context$RestaurantUsingXBeanTest));
    static /* synthetic */ Class class$org$apache$xbean$spring$context$RestaurantUsingXBeanTest;

    public void testPizza() throws Exception {
        RestaurantService restaurant = (RestaurantService)this.getBean("restaurant");
        QName name = restaurant.getServiceName();
        Assert.assertNotNull((String)"Name is null", (Object)name);
        Assert.assertEquals((String)"Namespace URI", (String)"http://acme.com", (String)name.getNamespaceURI());
        Assert.assertEquals((String)"localName", (String)"xyz", (String)name.getLocalPart());
        Assert.assertEquals((String)"prefix", (String)"foo", (String)name.getPrefix());
        List dinners = restaurant.getDinnerMenu();
        Assert.assertNotNull((String)"dinners is null!", (Object)dinners);
        Assert.assertEquals((String)("dinners size: " + dinners), (int)2, (int)dinners.size());
        PizzaService pizza = (PizzaService)dinners.get(0);
        Assert.assertEquals((String)"topping", (String)"Ham", (String)pizza.getTopping());
        Assert.assertEquals((String)"cheese", (String)"Mozzarella", (String)pizza.getCheese());
        Assert.assertEquals((String)"size", (int)15, (int)pizza.getSize());
        pizza = (PizzaService)dinners.get(1);
        Assert.assertEquals((String)"topping", (String)"Eggs", (String)pizza.getTopping());
        Assert.assertEquals((String)"cheese", (String)"Mozzarella", (String)pizza.getCheese());
        Assert.assertEquals((String)"size", (int)16, (int)pizza.getSize());
        PizzaService[] lunches = restaurant.getLunchMenu();
        Assert.assertNotNull((String)"lunches is null!", (Object)lunches);
        Assert.assertEquals((String)("lunches size: " + lunches), (int)1, (int)lunches.length);
        pizza = lunches[0];
        Assert.assertEquals((String)"topping", (String)"Chicken", (String)pizza.getTopping());
        Assert.assertEquals((String)"cheese", (String)"Brie", (String)pizza.getCheese());
        Assert.assertEquals((String)"size", (int)17, (int)pizza.getSize());
        pizza = restaurant.getFavourite();
        Assert.assertNotNull((String)"Pizza is null!", (Object)pizza);
        pizza.makePizza();
        Assert.assertEquals((String)"topping", (String)"Salami", (String)pizza.getTopping());
        Assert.assertEquals((String)"cheese", (String)"Edam", (String)pizza.getCheese());
        Assert.assertEquals((String)"size", (int)17, (int)pizza.getSize());
        URI uri = restaurant.getUri();
        Assert.assertNotNull((String)"URI is null", (Object)uri);
        Assert.assertEquals((String)"URI", (Object)new URI("http://cheese.com"), (Object)uri);
    }

    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/xbean/spring/context/restaurant-xbean.xml");
    }

    public void testCreateXBeanXmlBeanFactory() throws Exception {
        XBeanXmlBeanFactory factory = new XBeanXmlBeanFactory((Resource)new ClassPathResource("org/apache/xbean/spring/context/restaurant-xbean.xml"));
        Assert.assertNotNull((Object)factory);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

