/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.kernel;

import java.util.Set;
import org.apache.xbean.kernel.Kernel;
import org.apache.xbean.kernel.ServiceFactory;
import org.apache.xbean.kernel.ServiceName;

public class ServiceEvent {
    private final long eventId;
    private final Kernel kernel;
    private final ServiceName serviceName;
    private final ServiceFactory serviceFactory;
    private final ClassLoader classLoader;
    private final Object service;
    private final Throwable cause;
    private final Set unsatisfiedConditions;

    public ServiceEvent(long eventId, Kernel kernel, ServiceName serviceName, ServiceFactory serviceFactory, ClassLoader classLoader, Object service, Throwable cause, Set unsatisfiedConditions) {
        if (kernel == null) {
            throw new NullPointerException("kernel is null");
        }
        if (serviceName == null) {
            throw new NullPointerException("name is null");
        }
        if (serviceFactory == null) {
            throw new NullPointerException("serviceFactory is null");
        }
        if (classLoader == null) {
            throw new NullPointerException("classLoader is null");
        }
        if (unsatisfiedConditions != null && cause != null) {
            throw new IllegalArgumentException("Either unsatisfiedConditions or cause must be null");
        }
        if (cause != null && service != null) {
            throw new IllegalArgumentException("A ServiceEvent can not carry both a cause and a service");
        }
        this.eventId = eventId;
        this.kernel = kernel;
        this.serviceName = serviceName;
        this.serviceFactory = serviceFactory;
        this.classLoader = classLoader;
        this.service = service;
        this.cause = cause;
        this.unsatisfiedConditions = unsatisfiedConditions;
    }

    public long getEventId() {
        return this.eventId;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public ServiceName getServiceName() {
        return this.serviceName;
    }

    public ServiceFactory getServiceFactory() {
        return this.serviceFactory;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Object getService() {
        return this.service;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public Set getUnsatisfiedConditions() {
        return this.unsatisfiedConditions;
    }
}

