/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.client;

import com.ning.http.client.AsyncCompletionHandlerBase;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.wink.client.ClientConfig;
import org.apache.wink.client.ClientRequest;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.handlers.HandlerContext;
import org.apache.wink.client.internal.handlers.AbstractConnectionHandler;
import org.apache.wink.client.internal.handlers.ClientResponseImpl;
import org.apache.wink.common.internal.WinkConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncHttpClientConnectionHandler
extends AbstractConnectionHandler
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(AsyncHttpClientConnectionHandler.class);
    private AsyncHttpClient asyncHttpClient;

    public AsyncHttpClientConnectionHandler(AsyncHttpClient asyncHttpClient) {
        this.asyncHttpClient = asyncHttpClient;
    }

    public void close() throws IOException {
        this.asyncHttpClient.close();
    }

    public ClientResponse handle(ClientRequest request, HandlerContext context) throws Exception {
        Response response = this.processRequest(request, context);
        return this.processResponse(request, context, response);
    }

    private Response processRequest(ClientRequest cr, HandlerContext context) throws IOException {
        Response response;
        AsyncHttpClient asyncHttpClient = this.openConnection(cr);
        NonCloseableOutputStream ncos = new NonCloseableOutputStream();
        OutputStream os = this.adaptOutputStream(ncos, cr, context.getOutputStreamAdapters());
        Request request = this.setupHttpRequest(cr, ncos, os);
        final AtomicReference failureHolder = new AtomicReference();
        try {
            response = (Response)asyncHttpClient.executeRequest(request, (AsyncHandler)new AsyncCompletionHandlerBase(){

                public Response onCompleted(Response response) throws Exception {
                    logger.trace("Response received: {}", (Object)response);
                    return super.onCompleted(response);
                }

                public void onThrowable(Throwable t) {
                    logger.trace("Request failed", t);
                    failureHolder.set(t);
                }
            }).get();
        }
        catch (InterruptedException e) {
            throw (IOException)new IOException().initCause(e);
        }
        catch (ExecutionException e) {
            throw (IOException)new IOException().initCause(e);
        }
        Throwable failure = (Throwable)failureHolder.get();
        if (failure != null) {
            if (failure instanceof RuntimeException) {
                throw (RuntimeException)failure;
            }
            if (failure instanceof IOException) {
                throw (IOException)failure;
            }
            throw (IOException)new IOException().initCause(failure);
        }
        return response;
    }

    private Request setupHttpRequest(final ClientRequest cr, final NonCloseableOutputStream ncos, final OutputStream adaptedOutputStream) {
        URI uri = cr.getURI();
        String method = cr.getMethod();
        RequestBuilder builder = new RequestBuilder(method);
        builder.setUrl(uri.toString());
        MultivaluedMap headers = cr.getHeaders();
        for (String header : headers.keySet()) {
            List values = (List)headers.get((Object)header);
            for (String value : values) {
                if (value == null) continue;
                builder.addHeader(header, value);
            }
        }
        if (method.equalsIgnoreCase("PUT") || method.equalsIgnoreCase("POST")) {
            builder.setBody(new Request.EntityWriter(){

                public void writeEntity(OutputStream os) throws IOException {
                    ncos.setOutputStream(os);
                    AsyncHttpClientConnectionHandler.this.writeEntity(cr, adaptedOutputStream);
                }
            });
        }
        return builder.build();
    }

    private AsyncHttpClient openConnection(ClientRequest request) {
        if (this.asyncHttpClient != null) {
            return this.asyncHttpClient;
        }
        ClientConfig config = (ClientConfig)request.getAttribute(WinkConfiguration.class);
        AsyncHttpClientConfig.Builder c = new AsyncHttpClientConfig.Builder();
        c.setConnectionTimeoutInMs(config.getConnectTimeout());
        c.setRequestTimeoutInMs(config.getReadTimeout());
        c.setFollowRedirects(config.isFollowRedirects());
        if (config.getProxyHost() != null) {
            c.setProxyServer(new ProxyServer(config.getProxyHost(), config.getProxyPort()));
        }
        return new AsyncHttpClient(c.build());
    }

    private ClientResponse processResponse(ClientRequest request, HandlerContext context, Response response) throws IllegalStateException, IOException {
        ClientResponse cr = this.createResponse(request, response);
        InputStream is = response.hasResponseBody() ? response.getResponseBodyAsStream() : new EmptyInputStream();
        is = this.adaptInputStream(is, cr, context.getInputStreamAdapters());
        cr.setEntity((Object)is);
        return cr;
    }

    private ClientResponse createResponse(ClientRequest request, Response response) {
        ClientResponseImpl cr = new ClientResponseImpl();
        cr.setStatusCode(response.getStatusCode());
        cr.setMessage(response.getStatusText());
        cr.getAttributes().putAll(request.getAttributes());
        this.processResponseHeaders((ClientResponse)cr, response);
        return cr;
    }

    private void processResponseHeaders(ClientResponse cr, Response response) {
        FluentCaseInsensitiveStringsMap headers = response.getHeaders();
        for (Map.Entry header : headers) {
            for (String value : (List)header.getValue()) {
                cr.getHeaders().add(header.getKey(), (Object)value);
            }
        }
    }

    private static class NonCloseableOutputStream
    extends OutputStream {
        OutputStream os;

        public void setOutputStream(OutputStream os) {
            this.os = os;
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
            this.os.flush();
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.os.write(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            this.os.write(b);
        }

        public void write(int b) throws IOException {
            this.os.write(b);
        }
    }

    private static class EmptyInputStream
    extends InputStream {
        private EmptyInputStream() {
        }

        public int read() throws IOException {
            return -1;
        }
    }
}

