/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.example.jaxb;

import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.wink.example.jaxb.Address;
import org.apache.wink.example.jaxb.Person;
import org.apache.wink.example.jaxb.Phone;
import org.apache.wink.example.jaxb.Store;

@Path(value="info")
public class JaxbResource {
    private static Store store = new Store();

    @Path(value="person/{id}")
    @GET
    @Produces(value={"application/xml"})
    public Person getPerson(@PathParam(value="id") String id) {
        Person person = store.getPerson(id);
        if (person == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return person;
    }

    @Path(value="person/{id}")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public Response postPerson(@PathParam(value="id") String id, Person person) {
        store.putPerson(id, person);
        return Response.created((URI)URI.create("info/" + id)).entity((Object)this.getPerson(id)).build();
    }

    @Path(value="address/{id}")
    @GET
    @Produces(value={"application/xml"})
    public Address getAddress(@PathParam(value="id") String id) {
        Address address = store.getAddress(id);
        if (address == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return address;
    }

    @Path(value="address/{id}")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public Response postAddress(@PathParam(value="id") String id, Address address) {
        store.putAddress(id, address);
        return Response.created((URI)URI.create("info/" + id)).entity((Object)this.getAddress(id)).build();
    }

    @Path(value="phone/{id}")
    @GET
    @Produces(value={"application/xml"})
    public Phone getPhone(@PathParam(value="id") String id) {
        Phone phone = store.getPhone(id);
        if (phone == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return phone;
    }

    @Path(value="phone/{id}")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public Response postPhone(@PathParam(value="id") String id, Phone phone) {
        store.putPhone(id, phone);
        return Response.created((URI)URI.create("info/" + id)).entity((Object)this.getPhone(id)).build();
    }
}

