/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.example.asset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.apache.wink.common.annotations.Asset;
import org.apache.wink.common.model.synd.SyndEntry;
import org.apache.wink.common.model.synd.SyndFeed;
import org.apache.wink.common.model.synd.SyndPerson;
import org.apache.wink.common.model.synd.SyndText;
import org.apache.wink.example.asset.User;
import org.apache.wink.example.asset.Users;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Asset
public class UsersAsset {
    private List<User> users;

    public UsersAsset(Collection<User> users) {
        this.users = new ArrayList(users.size());
        this.users.addAll(users);
    }

    @Produces(value={"application/xml"})
    public Users getUsers() {
        return new Users((Collection)this.users);
    }

    @Produces(value={"application/atom+xml", "application/json"})
    public SyndFeed getSyndFeed(@Context Providers providers, @Context UriInfo uriInfo) {
        SyndFeed synd = new SyndFeed();
        synd.setId("urn:com:hp:users");
        synd.setTitle(new SyndText("Users"));
        synd.addAuthor(new SyndPerson("admin"));
        synd.setUpdated(new Date());
        for (User user : this.users) {
            SyndEntry entry = new SyndEntry();
            entry.setId(Integer.toString(user.getId()));
            entry.setPublished(new Date(System.currentTimeMillis()));
            entry.setUpdated(new Date(System.currentTimeMillis()));
            entry.setTitle(new SyndText(user.getLastName() + " " + user.getFirstName()));
            synd.addEntry(entry);
        }
        synd.setBase(uriInfo.getAbsolutePath().toString());
        return synd;
    }
}

