/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.tomcat7;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.util.Base64;
import org.apache.coyote.http11.upgrade.UpgradeInbound;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.ws.AbstractUpgradeFilter;
import org.apache.wicket.protocol.ws.tomcat7.TomcatWebSocketProcessor;

public class Tomcat7WebSocketFilter
extends AbstractUpgradeFilter {
    private static final byte[] WS_ACCEPT = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11".getBytes(B2CConverter.ISO_8859_1);
    private MessageDigest sha1Helper;

    public void init(boolean isServlet, FilterConfig filterConfig) throws ServletException {
        super.init(isServlet, filterConfig);
        try {
            this.sha1Helper = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected boolean acceptWebSocket(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!super.acceptWebSocket(req, resp)) {
            return false;
        }
        resp.setHeader("upgrade", "websocket");
        resp.setHeader("connection", "upgrade");
        String key = req.getHeader("Sec-WebSocket-Key");
        resp.setHeader("Sec-WebSocket-Accept", this.getWebSocketAccept(key));
        WebApplication application = this.getApplication();
        TomcatWebSocketProcessor webSocketHandler = new TomcatWebSocketProcessor(req, application);
        TomcatWebSocketProcessor.TomcatWebSocket tomcatWebSocket = new TomcatWebSocketProcessor.TomcatWebSocket(webSocketHandler);
        while (req instanceof HttpServletRequestWrapper) {
            req = (HttpServletRequest)((HttpServletRequestWrapper)req).getRequest();
        }
        ((RequestFacade)req).doUpgrade((UpgradeInbound)tomcatWebSocket);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getWebSocketAccept(String key) {
        MessageDigest messageDigest = this.sha1Helper;
        synchronized (messageDigest) {
            this.sha1Helper.reset();
            this.sha1Helper.update(key.getBytes(B2CConverter.ISO_8859_1));
            return Base64.encode((byte[])this.sha1Helper.digest(WS_ACCEPT));
        }
    }
}

