/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.tomcat7;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.websocket.MessageInbound;
import org.apache.catalina.websocket.WsOutbound;
import org.apache.wicket.Application;
import org.apache.wicket.protocol.ws.api.AbstractWebSocketProcessor;
import org.apache.wicket.protocol.ws.api.IWebSocketConnection;
import org.apache.wicket.protocol.ws.tomcat7.TomcatWebSocketConnection;

public class TomcatWebSocketProcessor
extends AbstractWebSocketProcessor {
    public TomcatWebSocketProcessor(HttpServletRequest request, Application application) {
        super(request, application);
    }

    public void onOpen(Object containerConnection) {
        if (!(containerConnection instanceof WsOutbound)) {
            throw new IllegalArgumentException(TomcatWebSocketProcessor.class.getName() + " can work only with " + WsOutbound.class.getName());
        }
        this.onConnect((IWebSocketConnection)new TomcatWebSocketConnection((WsOutbound)containerConnection, this));
    }

    public class TomcatWebSocket
    extends MessageInbound {
        protected void onBinaryMessage(ByteBuffer byteBuffer) throws IOException {
            byte[] bytes = byteBuffer.array();
            int offset = byteBuffer.position();
            int length = byteBuffer.limit() - offset;
            TomcatWebSocketProcessor.this.onMessage(bytes, offset, length);
        }

        protected void onTextMessage(CharBuffer charBuffer) throws IOException {
            TomcatWebSocketProcessor.this.onMessage(charBuffer.toString());
        }

        protected void onOpen(WsOutbound outbound) {
            TomcatWebSocketProcessor.this.onOpen(outbound);
        }

        protected void onClose(int status) {
            TomcatWebSocketProcessor.this.onClose(status, "Connection closed by client");
        }
    }
}

