/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.api;

import org.apache.wicket.Component;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.protocol.ws.api.BaseWebSocketBehavior;
import org.apache.wicket.protocol.ws.api.WebSocketRequestHandler;
import org.apache.wicket.protocol.ws.api.event.WebSocketAbortedPayload;
import org.apache.wicket.protocol.ws.api.event.WebSocketBinaryPayload;
import org.apache.wicket.protocol.ws.api.event.WebSocketClosedPayload;
import org.apache.wicket.protocol.ws.api.event.WebSocketConnectedPayload;
import org.apache.wicket.protocol.ws.api.event.WebSocketPayload;
import org.apache.wicket.protocol.ws.api.event.WebSocketPushPayload;
import org.apache.wicket.protocol.ws.api.event.WebSocketTextPayload;
import org.apache.wicket.protocol.ws.api.message.AbortedMessage;
import org.apache.wicket.protocol.ws.api.message.BinaryMessage;
import org.apache.wicket.protocol.ws.api.message.ClosedMessage;
import org.apache.wicket.protocol.ws.api.message.ConnectedMessage;
import org.apache.wicket.protocol.ws.api.message.IWebSocketPushMessage;
import org.apache.wicket.protocol.ws.api.message.TextMessage;

public abstract class WebSocketBehavior
extends BaseWebSocketBehavior {
    public void onEvent(Component component, IEvent<?> event) {
        super.onEvent(component, event);
        Object payload = event.getPayload();
        if (payload instanceof WebSocketPayload) {
            WebSocketPayload wsPayload = (WebSocketPayload)payload;
            WebSocketRequestHandler webSocketHandler = wsPayload.getHandler();
            if (payload instanceof WebSocketTextPayload) {
                WebSocketTextPayload textPayload = (WebSocketTextPayload)payload;
                TextMessage data = textPayload.getMessage();
                this.onMessage(webSocketHandler, data);
            } else if (wsPayload instanceof WebSocketBinaryPayload) {
                WebSocketBinaryPayload binaryPayload = (WebSocketBinaryPayload)wsPayload;
                BinaryMessage binaryData = binaryPayload.getMessage();
                this.onMessage(webSocketHandler, binaryData);
            } else if (wsPayload instanceof WebSocketConnectedPayload) {
                WebSocketConnectedPayload connectedPayload = (WebSocketConnectedPayload)wsPayload;
                ConnectedMessage message = connectedPayload.getMessage();
                this.onConnect(message);
            } else if (wsPayload instanceof WebSocketClosedPayload) {
                WebSocketClosedPayload closedPayload = (WebSocketClosedPayload)wsPayload;
                ClosedMessage message = closedPayload.getMessage();
                this.onClose(message);
            } else if (wsPayload instanceof WebSocketAbortedPayload) {
                WebSocketAbortedPayload abortedPayload = (WebSocketAbortedPayload)wsPayload;
                AbortedMessage message = abortedPayload.getMessage();
                this.onAbort(message);
            } else if (wsPayload instanceof WebSocketPushPayload) {
                WebSocketPushPayload pushPayload = (WebSocketPushPayload)wsPayload;
                IWebSocketPushMessage message = pushPayload.getMessage();
                this.onPush(webSocketHandler, message);
            }
        }
    }

    protected void onPush(WebSocketRequestHandler handler, IWebSocketPushMessage message) {
    }

    protected void onConnect(ConnectedMessage message) {
    }

    protected void onClose(ClosedMessage message) {
    }

    protected void onAbort(AbortedMessage message) {
    }

    protected void onMessage(WebSocketRequestHandler handler, TextMessage message) {
    }

    protected void onMessage(WebSocketRequestHandler handler, BinaryMessage binaryMessage) {
    }
}

