/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws;

import java.util.concurrent.Callable;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Page;
import org.apache.wicket.protocol.ws.api.IWebSocketConnection;
import org.apache.wicket.protocol.ws.api.IWebSocketConnectionFilter;
import org.apache.wicket.protocol.ws.api.WebSocketRequestHandler;
import org.apache.wicket.protocol.ws.api.WebSocketResponse;
import org.apache.wicket.protocol.ws.api.registry.IWebSocketConnectionRegistry;
import org.apache.wicket.protocol.ws.api.registry.SimpleWebSocketConnectionRegistry;
import org.apache.wicket.protocol.ws.concurrent.Executor;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.lang.Args;

public class WebSocketSettings {
    private static final MetaDataKey<WebSocketSettings> KEY = new MetaDataKey<WebSocketSettings>(){};
    private Executor webSocketPushMessageExecutor = new SameThreadExecutor();
    private Executor sendPayloadExecutor = new SameThreadExecutor();
    private IWebSocketConnectionRegistry connectionRegistry = new SimpleWebSocketConnectionRegistry();
    private IWebSocketConnectionFilter connectionFilter;

    public WebSocketSettings setWebSocketPushMessageExecutor(Executor executor) {
        Args.notNull((Object)executor, (String)"executor");
        this.webSocketPushMessageExecutor = executor;
        return this;
    }

    public Executor getWebSocketPushMessageExecutor() {
        return this.webSocketPushMessageExecutor;
    }

    public IWebSocketConnectionRegistry getConnectionRegistry() {
        return this.connectionRegistry;
    }

    public WebSocketSettings setConnectionRegistry(IWebSocketConnectionRegistry connectionRegistry) {
        Args.notNull((Object)connectionRegistry, (String)"connectionRegistry");
        this.connectionRegistry = connectionRegistry;
        return this;
    }

    public WebSocketSettings setSendPayloadExecutor(Executor sendPayloadExecutor) {
        Args.notNull((Object)sendPayloadExecutor, (String)"sendPayloadExecutor");
        this.sendPayloadExecutor = sendPayloadExecutor;
        return this;
    }

    public Executor getSendPayloadExecutor() {
        return this.sendPayloadExecutor;
    }

    public void setConnectionFilter(IWebSocketConnectionFilter connectionFilter) {
        this.connectionFilter = connectionFilter;
    }

    public IWebSocketConnectionFilter getConnectionFilter() {
        return this.connectionFilter;
    }

    public WebResponse newWebSocketResponse(IWebSocketConnection connection) {
        return new WebSocketResponse(connection);
    }

    public WebSocketRequestHandler newWebSocketRequestHandler(Page page, IWebSocketConnection connection) {
        return new WebSocketRequestHandler((Component)page, connection);
    }

    public static class SameThreadExecutor
    implements Executor {
        @Override
        public void run(Runnable command) {
            command.run();
        }

        @Override
        public <T> T call(Callable<T> callable) throws Exception {
            return callable.call();
        }
    }

    public static final class Holder {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static WebSocketSettings get(Application application) {
            WebSocketSettings settings = (WebSocketSettings)application.getMetaData(KEY);
            if (settings == null) {
                Application application2 = application;
                synchronized (application2) {
                    if (settings == null) {
                        settings = new WebSocketSettings();
                        Holder.set(application, settings);
                    }
                }
            }
            return settings;
        }

        public static void set(Application application, WebSocketSettings settings) {
            application.setMetaData(KEY, (Object)settings);
        }
    }
}

