/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.util.tester;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.wicket.Application;
import org.apache.wicket.Page;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.mock.MockHttpServletRequest;
import org.apache.wicket.protocol.http.mock.MockHttpSession;
import org.apache.wicket.protocol.ws.api.AbstractWebSocketProcessor;
import org.apache.wicket.protocol.ws.api.message.IWebSocketPushMessage;
import org.apache.wicket.protocol.ws.util.tester.TestWebSocketConnection;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.tester.WicketTester;

abstract class TestWebSocketProcessor
extends AbstractWebSocketProcessor {
    public TestWebSocketProcessor(WicketTester wicketTester, Page page) {
        super(TestWebSocketProcessor.createRequest(wicketTester, page), (WebApplication)page.getApplication());
    }

    private static HttpServletRequest createRequest(WicketTester wicketTester, Page page) {
        Args.notNull((Object)page, (String)"page");
        Application application = page.getApplication();
        MockHttpSession httpSession = wicketTester.getHttpSession();
        MockHttpServletRequest request = new MockHttpServletRequest(application, (HttpSession)httpSession, null);
        request.addParameter("pageId", page.getId());
        request.addParameter("wicket-ajax-baseurl", ".");
        return request;
    }

    @Override
    public void onOpen(Object connection) {
        this.onConnect(new TestWebSocketConnection(){

            @Override
            protected void onOutMessage(String message) {
                TestWebSocketProcessor.this.onOutMessage(message);
            }

            @Override
            protected void onOutMessage(byte[] message, int offset, int length) {
                TestWebSocketProcessor.this.onOutMessage(message, offset, length);
            }

            @Override
            public void sendMessage(IWebSocketPushMessage message) {
                TestWebSocketProcessor.this.broadcastMessage(message);
            }
        });
    }

    protected abstract void onOutMessage(String var1);

    protected abstract void onOutMessage(byte[] var1, int var2, int var3);
}

