/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.api;

import java.util.Collection;
import java.util.Collections;
import org.apache.wicket.Application;
import org.apache.wicket.protocol.ws.IWebSocketSettings;
import org.apache.wicket.protocol.ws.api.IWebSocketConnection;
import org.apache.wicket.protocol.ws.api.IWebSocketConnectionRegistry;
import org.apache.wicket.protocol.ws.api.message.ConnectedMessage;
import org.apache.wicket.protocol.ws.api.message.IWebSocketPushMessage;
import org.apache.wicket.protocol.ws.concurrent.Executor;
import org.apache.wicket.util.lang.Args;

public class WebSocketPushBroadcaster {
    private final IWebSocketConnectionRegistry registry;

    public WebSocketPushBroadcaster(IWebSocketConnectionRegistry registry) {
        Args.notNull((Object)registry, (String)"registry");
        this.registry = registry;
    }

    public void broadcast(ConnectedMessage connection, IWebSocketPushMessage message) {
        Args.notNull((Object)connection, (String)"connection");
        Args.notNull((Object)message, (String)"message");
        Application application = connection.getApplication();
        String sessionId = connection.getSessionId();
        Integer pageId = connection.getPageId();
        IWebSocketConnection wsConnection = this.registry.getConnection(application, sessionId, pageId);
        if (wsConnection == null) {
            return;
        }
        this.process(application, Collections.singletonList(wsConnection), message);
    }

    public void broadcastAll(Application application, IWebSocketPushMessage message) {
        Args.notNull((Object)application, (String)"application");
        Args.notNull((Object)message, (String)"message");
        Collection<IWebSocketConnection> wsConnections = this.registry.getConnections(application);
        if (wsConnections == null) {
            return;
        }
        this.process(application, wsConnections, message);
    }

    private void process(Application application, Collection<IWebSocketConnection> wsConnections, final IWebSocketPushMessage message) {
        IWebSocketSettings webSocketSettings = IWebSocketSettings.Holder.get(application);
        Executor executor = webSocketSettings.getWebSocketPushMessageExecutor();
        for (final IWebSocketConnection wsConnection : wsConnections) {
            executor.run(new Runnable(){

                @Override
                public void run() {
                    wsConnection.sendMessage(message);
                }
            });
        }
    }
}

