/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.api;

import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.protocol.ws.api.WebSocketRequestHandler;
import org.apache.wicket.protocol.ws.api.WicketWebSocketJQueryResourceReference;
import org.apache.wicket.protocol.ws.api.event.WebSocketBinaryPayload;
import org.apache.wicket.protocol.ws.api.event.WebSocketClosedPayload;
import org.apache.wicket.protocol.ws.api.event.WebSocketConnectedPayload;
import org.apache.wicket.protocol.ws.api.event.WebSocketPayload;
import org.apache.wicket.protocol.ws.api.event.WebSocketTextPayload;
import org.apache.wicket.protocol.ws.api.message.BinaryMessage;
import org.apache.wicket.protocol.ws.api.message.ClosedMessage;
import org.apache.wicket.protocol.ws.api.message.ConnectedMessage;
import org.apache.wicket.protocol.ws.api.message.TextMessage;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.template.PackageTextTemplate;

public abstract class WebSocketBehavior
extends Behavior {
    public void onEvent(Component component, IEvent<?> event) {
        Object payload = event.getPayload();
        if (payload instanceof WebSocketPayload) {
            WebSocketPayload wsPayload = (WebSocketPayload)payload;
            WebSocketRequestHandler webSocketHandler = wsPayload.getHandler();
            if (payload instanceof WebSocketTextPayload) {
                WebSocketTextPayload textPayload = (WebSocketTextPayload)payload;
                TextMessage data = textPayload.getMessage();
                this.onMessage(webSocketHandler, data);
            } else if (wsPayload instanceof WebSocketBinaryPayload) {
                WebSocketBinaryPayload binaryPayload = (WebSocketBinaryPayload)wsPayload;
                BinaryMessage binaryData = binaryPayload.getMessage();
                this.onMessage(webSocketHandler, binaryData);
            } else if (wsPayload instanceof WebSocketConnectedPayload) {
                WebSocketConnectedPayload connectedPayload = (WebSocketConnectedPayload)wsPayload;
                ConnectedMessage message = connectedPayload.getMessage();
                this.onConnect(message);
            } else if (wsPayload instanceof WebSocketClosedPayload) {
                WebSocketClosedPayload connectedPayload = (WebSocketClosedPayload)wsPayload;
                ClosedMessage message = connectedPayload.getMessage();
                this.onClose(message);
            }
        }
    }

    protected void onConnect(ConnectedMessage message) {
    }

    protected void onClose(ClosedMessage message) {
    }

    protected void onMessage(WebSocketRequestHandler handler, TextMessage message) {
    }

    protected void onMessage(WebSocketRequestHandler handler, BinaryMessage binaryMessage) {
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)WicketWebSocketJQueryResourceReference.get()));
        PackageTextTemplate webSocketSetupTemplate = new PackageTextTemplate(WicketWebSocketJQueryResourceReference.class, "res/js/wicket-websocket-setup.js.tmpl");
        HashMap variables = Generics.newHashMap();
        int pageId = component.getPage().getPageId();
        variables.put("pageId", pageId);
        Url baseUrl = component.getRequestCycle().getUrlRenderer().getBaseUrl();
        CharSequence ajaxBaseUrl = Strings.escapeMarkup((CharSequence)baseUrl.toString());
        variables.put("baseUrl", ajaxBaseUrl);
        String webSocketSetupScript = webSocketSetupTemplate.asString((Map)variables);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)webSocketSetupScript));
    }

    public boolean getStatelessHint(Component component) {
        return false;
    }
}

