/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.protocol.ws.api.IWebSocketConnection;
import org.apache.wicket.protocol.ws.api.IWebSocketConnectionRegistry;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Generics;

public class SimpleWebSocketConnectionRegistry
implements IWebSocketConnectionRegistry {
    private static final MetaDataKey<ConcurrentMap<String, ConcurrentMap<Integer, IWebSocketConnection>>> KEY = new MetaDataKey<ConcurrentMap<String, ConcurrentMap<Integer, IWebSocketConnection>>>(){};

    @Override
    public IWebSocketConnection getConnection(Application application, String sessionId, Integer pageId) {
        ConcurrentMap connectionsByPage;
        Args.notNull((Object)application, (String)"application");
        Args.notNull((Object)sessionId, (String)"sessionId");
        Args.notNull((Object)pageId, (String)"pageId");
        IWebSocketConnection connection = null;
        ConcurrentMap connectionsBySession = (ConcurrentMap)application.getMetaData(KEY);
        if (connectionsBySession != null && (connectionsByPage = (ConcurrentMap)connectionsBySession.get(sessionId)) != null) {
            connection = (IWebSocketConnection)connectionsByPage.get(pageId);
        }
        return connection;
    }

    @Override
    public Collection<IWebSocketConnection> getConnections(Application application) {
        Args.notNull((Object)application, (String)"application");
        ArrayList<IWebSocketConnection> connections = new ArrayList<IWebSocketConnection>();
        ConcurrentMap connectionsBySession = (ConcurrentMap)application.getMetaData(KEY);
        if (connectionsBySession != null) {
            for (ConcurrentMap connectionsByPage : connectionsBySession.values()) {
                connections.addAll(connectionsByPage.values());
            }
        }
        return connections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConnection(Application application, String sessionId, Integer pageId, IWebSocketConnection connection) {
        ConcurrentMap connectionsByPage;
        Args.notNull((Object)application, (String)"application");
        Args.notNull((Object)sessionId, (String)"sessionId");
        Args.notNull((Object)pageId, (String)"pageId");
        ConcurrentMap connectionsBySession = (ConcurrentMap)application.getMetaData(KEY);
        if (connectionsBySession == null) {
            MetaDataKey<ConcurrentMap<String, ConcurrentMap<Integer, IWebSocketConnection>>> metaDataKey = KEY;
            synchronized (metaDataKey) {
                connectionsBySession = (ConcurrentMap)application.getMetaData(KEY);
                if (connectionsBySession == null) {
                    connectionsBySession = Generics.newConcurrentHashMap();
                    application.setMetaData(KEY, (Object)connectionsBySession);
                }
            }
        }
        if ((connectionsByPage = (ConcurrentMap)connectionsBySession.get(sessionId)) == null && connection != null) {
            ConcurrentMap concurrentMap = connectionsBySession;
            synchronized (concurrentMap) {
                connectionsByPage = (ConcurrentMap)connectionsBySession.get(sessionId);
                if (connectionsByPage == null) {
                    connectionsByPage = Generics.newConcurrentHashMap();
                    connectionsBySession.put(sessionId, connectionsByPage);
                }
            }
        }
        if (connection != null) {
            connectionsByPage.put(pageId, connection);
        } else if (connectionsByPage != null) {
            connectionsByPage.remove(pageId);
            if (connectionsByPage.isEmpty()) {
                connectionsBySession.remove(sessionId);
            }
        }
    }

    @Override
    public void removeConnection(Application application, String sessionId, Integer pageId) {
        this.setConnection(application, sessionId, pageId, null);
    }
}

