/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.protocol.http.WicketFilter;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;

public class AbstractUpgradeFilter
extends WicketFilter {
    protected boolean processRequestCycle(RequestCycle requestCycle, WebResponse webResponse, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain chain) throws IOException, ServletException {
        boolean res = true;
        ThreadContext.setRequestCycle((RequestCycle)requestCycle);
        if (this.acceptWebSocket(httpServletRequest, httpServletResponse) || httpServletResponse.isCommitted()) {
            res = true;
        } else if (!requestCycle.processRequestAndDetach() && !httpServletResponse.isCommitted()) {
            if (chain != null) {
                chain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
            res = false;
        } else {
            webResponse.flush();
        }
        return res;
    }

    protected boolean acceptWebSocket(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String subProtocol = null;
        List extensions = Collections.emptyList();
        if (!this.headerContainsToken(req, "upgrade", "websocket")) {
            return false;
        }
        if (!this.headerContainsToken(req, "connection", "upgrade")) {
            resp.sendError(400);
            return false;
        }
        if (!this.headerContainsToken(req, "sec-websocket-version", "13")) {
            resp.setStatus(426);
            resp.setHeader("Sec-WebSocket-Version", "13");
            return false;
        }
        String key = req.getHeader("Sec-WebSocket-Key");
        if (key == null) {
            resp.sendError(400);
            return false;
        }
        String origin = req.getHeader("Origin");
        if (!this.verifyOrigin(origin)) {
            resp.sendError(403);
            return false;
        }
        List<String> subProtocols = this.getTokensFromHeader(req, "Sec-WebSocket-Protocol-Client");
        if (!subProtocols.isEmpty()) {
            subProtocol = this.selectSubProtocol(subProtocols);
        }
        resp.setHeader("upgrade", "websocket");
        resp.setHeader("connection", "upgrade");
        if (subProtocol != null) {
            resp.setHeader("Sec-WebSocket-Protocol", subProtocol);
        }
        return true;
    }

    private boolean headerContainsToken(HttpServletRequest req, String headerName, String target) {
        Enumeration headers = req.getHeaders(headerName);
        while (headers.hasMoreElements()) {
            String[] tokens;
            String header = (String)headers.nextElement();
            for (String token : tokens = header.split(",")) {
                if (!target.equalsIgnoreCase(token.trim())) continue;
                return true;
            }
        }
        return false;
    }

    protected List<String> getTokensFromHeader(HttpServletRequest req, String headerName) {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration headers = req.getHeaders(headerName);
        while (headers.hasMoreElements()) {
            String[] tokens;
            String header = (String)headers.nextElement();
            for (String token : tokens = header.split(",")) {
                result.add(token.trim());
            }
        }
        return result;
    }

    protected boolean verifyOrigin(String origin) {
        return true;
    }

    protected String selectSubProtocol(List<String> subProtocols) {
        return null;
    }
}

