/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.util.tester;

import org.apache.wicket.Page;
import org.apache.wicket.protocol.ws.api.IWebSocketProcessor;
import org.apache.wicket.protocol.ws.util.tester.TestWebSocketProcessor;
import org.apache.wicket.util.lang.Args;

public class WebSocketTester {
    private final IWebSocketProcessor socketProcessor;

    public WebSocketTester(Page page) {
        Args.notNull((Object)page, (String)"page");
        this.socketProcessor = new TestWebSocketProcessor(page){

            @Override
            protected void onOutMessage(String message) {
                WebSocketTester.this.onOutMessage(message);
            }

            @Override
            protected void onOutMessage(byte[] message, int offset, int length) {
                WebSocketTester.this.onOutMessage(message, offset, length);
            }
        };
        this.socketProcessor.onOpen(null);
    }

    public void sendMessage(String message) {
        this.socketProcessor.onMessage(message);
    }

    public void sendMessage(byte[] message, int offset, int length) {
        this.socketProcessor.onMessage(message, offset, length);
    }

    public void destroy() {
        this.socketProcessor.onClose(0, "Closed by WicketTester");
    }

    protected void onOutMessage(String message) {
    }

    protected void onOutMessage(byte[] message, int offset, int length) {
    }
}

