/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.api;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.wicket.protocol.ws.api.IWebSocketConnection;
import org.apache.wicket.request.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketResponse
extends Response {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketResponse.class);
    private final IWebSocketConnection connection;
    private StringBuilder text;
    private ByteArrayOutputStream binary;

    public WebSocketResponse(IWebSocketConnection conn) {
        this.connection = conn;
    }

    public void write(CharSequence sequence) {
        if (this.text == null) {
            this.text = new StringBuilder();
        }
        this.text.append(sequence);
    }

    public void write(byte[] array) {
        this.write(array, 0, array.length);
    }

    public void write(byte[] array, int offset, int length) {
        if (this.binary == null) {
            this.binary = new ByteArrayOutputStream();
        }
        this.binary.write(array, offset, length);
    }

    public void close() {
        if (this.connection.isOpen()) {
            try {
                if (this.text != null) {
                    this.connection.sendMessage(this.text.toString());
                    this.text = null;
                } else if (this.binary != null) {
                    byte[] bytes = this.binary.toByteArray();
                    this.connection.sendMessage(bytes, 0, bytes.length);
                    this.binary.close();
                    this.binary = null;
                }
            }
            catch (IOException iox) {
                LOG.error("An error occurred while writing response to WebSocket client.", (Throwable)iox);
            }
        }
        super.close();
    }

    public void reset() {
        if (this.text != null) {
            this.text = null;
        }
        if (this.binary != null) {
            try {
                this.binary.close();
            }
            catch (IOException iox) {
                LOG.error("An error occurred while resetting the binary content", (Throwable)iox);
            }
            this.binary = null;
        }
        super.reset();
    }

    public String encodeURL(CharSequence url) {
        return ((Object)url).toString();
    }

    public final IWebSocketConnection getContainerResponse() {
        return this.connection;
    }
}

