/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.api;

import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.ajax.WebSocketRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.page.IPageManager;
import org.apache.wicket.protocol.ws.api.IWebSocketConnection;
import org.apache.wicket.protocol.ws.api.IWebSocketConnectionRegistry;
import org.apache.wicket.protocol.ws.api.IWebSocketProcessor;
import org.apache.wicket.protocol.ws.api.ServletRequestCopy;
import org.apache.wicket.protocol.ws.api.SimpleWebSocketConnectionRegistry;
import org.apache.wicket.protocol.ws.api.WebSocketRequest;
import org.apache.wicket.protocol.ws.api.WebSocketResponse;
import org.apache.wicket.protocol.ws.api.event.WebSocketBinaryPayload;
import org.apache.wicket.protocol.ws.api.event.WebSocketClosedPayload;
import org.apache.wicket.protocol.ws.api.event.WebSocketConnectedPayload;
import org.apache.wicket.protocol.ws.api.event.WebSocketPayload;
import org.apache.wicket.protocol.ws.api.event.WebSocketTextPayload;
import org.apache.wicket.protocol.ws.api.message.BinaryMessage;
import org.apache.wicket.protocol.ws.api.message.ClosedMessage;
import org.apache.wicket.protocol.ws.api.message.ConnectedMessage;
import org.apache.wicket.protocol.ws.api.message.IWebSocketMessage;
import org.apache.wicket.protocol.ws.api.message.TextMessage;
import org.apache.wicket.request.IExceptionMapper;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.cycle.RequestCycleContext;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.session.ISessionStore;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Checks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWebSocketProcessor
implements IWebSocketProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWebSocketProcessor.class);
    private final WebRequest webRequest;
    private final int pageId;
    private final Application application;
    private final String sessionId;
    private final IWebSocketConnectionRegistry connectionRegistry;

    public AbstractWebSocketProcessor(HttpServletRequest request, Application application) {
        this.sessionId = request.getSession(true).getId();
        Session.get().bind();
        String pageId = request.getParameter("pageId");
        Checks.notEmpty((String)pageId, (String)"Request parameter 'pageId' is required!", (Object[])new Object[0]);
        this.pageId = Integer.parseInt(pageId, 10);
        this.webRequest = new WebSocketRequest(new ServletRequestCopy(request));
        this.application = (Application)Args.notNull((Object)application, (String)"application");
        this.connectionRegistry = new SimpleWebSocketConnectionRegistry();
    }

    @Override
    public void onMessage(String message) {
        this.broadcastMessage(new TextMessage(message));
    }

    @Override
    public void onMessage(byte[] data, int offset, int length) {
        BinaryMessage binaryMessage = new BinaryMessage(data, offset, length);
        this.broadcastMessage(binaryMessage);
    }

    protected final void onConnect(IWebSocketConnection connection) {
        this.connectionRegistry.setConnection(this.getApplication(), this.getSessionId(), this.pageId, connection);
        this.broadcastMessage(new ConnectedMessage(this.getApplication(), this.getSessionId(), this.pageId));
    }

    @Override
    public void onClose(int closeCode, String message) {
        this.broadcastMessage(new ClosedMessage(this.getApplication(), this.getSessionId(), this.pageId));
        this.connectionRegistry.removeConnection(this.application, this.sessionId, this.pageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void broadcastMessage(IWebSocketMessage message) {
        IWebSocketConnection connection = this.connectionRegistry.getConnection(this.application, this.sessionId, this.pageId);
        if (connection != null && connection.isOpen()) {
            Application oldApplication = ThreadContext.getApplication();
            Session oldSession = ThreadContext.getSession();
            RequestCycle oldRequestCycle = ThreadContext.getRequestCycle();
            WebSocketResponse webResponse = new WebSocketResponse(connection);
            try {
                Session session;
                RequestCycle requestCycle;
                if (oldRequestCycle == null) {
                    RequestCycleContext context = new RequestCycleContext((Request)this.webRequest, (Response)webResponse, this.application.getRootRequestMapper(), (IExceptionMapper)this.application.getExceptionMapperProvider().get());
                    requestCycle = (RequestCycle)this.application.getRequestCycleProvider().get((Object)context);
                    ThreadContext.setRequestCycle((RequestCycle)requestCycle);
                } else {
                    requestCycle = oldRequestCycle;
                }
                ThreadContext.setApplication((Application)this.application);
                if (oldSession == null) {
                    ISessionStore sessionStore = this.application.getSessionStore();
                    session = sessionStore.lookup((Request)this.webRequest);
                    ThreadContext.setSession((Session)session);
                } else {
                    session = oldSession;
                }
                IPageManager pageManager = session.getPageManager();
                try {
                    Page page = (Page)pageManager.getPage(this.pageId);
                    WebSocketRequestHandler target = new WebSocketRequestHandler((Component)page, connection);
                    WebSocketPayload payload = this.createEventPayload(message, target);
                    page.send((IEventSink)this.application, Broadcast.BREADTH, (Object)payload);
                    if (message instanceof ConnectedMessage || message instanceof ClosedMessage) return;
                    target.respond((IRequestCycle)requestCycle);
                    return;
                }
                finally {
                    pageManager.commitRequest();
                }
            }
            catch (Exception x) {
                LOG.error("An error occurred during processing of a WebSocket message", (Throwable)x);
                return;
            }
            finally {
                try {
                    webResponse.close();
                }
                finally {
                    ThreadContext.setApplication((Application)oldApplication);
                    ThreadContext.setRequestCycle((RequestCycle)oldRequestCycle);
                    ThreadContext.setSession((Session)oldSession);
                }
            }
        }
        LOG.debug("Either there is no connection({}) or it is closed.", (Object)connection);
    }

    protected final Application getApplication() {
        return this.application;
    }

    protected final String getSessionId() {
        return this.sessionId;
    }

    private WebSocketPayload createEventPayload(IWebSocketMessage message, WebSocketRequestHandler handler) {
        WebSocketPayload payload;
        if (message instanceof TextMessage) {
            payload = new WebSocketTextPayload((TextMessage)message, handler);
        } else if (message instanceof BinaryMessage) {
            payload = new WebSocketBinaryPayload((BinaryMessage)message, handler);
        } else if (message instanceof ConnectedMessage) {
            payload = new WebSocketConnectedPayload((ConnectedMessage)message, handler);
        } else if (message instanceof ClosedMessage) {
            payload = new WebSocketClosedPayload((ClosedMessage)message, handler);
        } else {
            throw new IllegalArgumentException("Unsupported message type: " + message.getClass().getName());
        }
        return payload;
    }
}

