/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.elasticsearch;

import java.io.IOException;
import org.apache.commons.configuration.Configuration;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.RolePredicates;
import org.apache.whirr.service.ClusterActionEvent;
import org.apache.whirr.service.ClusterActionHandlerSupport;
import org.apache.whirr.service.FirewallManager;
import org.apache.whirr.service.elasticsearch.ElasticSearchConfigurationBuilder;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;

public class ElasticSearchHandler
extends ClusterActionHandlerSupport {
    public static final String ROLE = "elasticsearch";
    public static final int HTTP_CLIENT_PORT = 9200;

    public String getRole() {
        return ROLE;
    }

    protected void beforeBootstrap(ClusterActionEvent event) throws IOException {
        ClusterSpec spec = event.getClusterSpec();
        Configuration config = spec.getConfiguration();
        ElasticSearchHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"retry_helpers", (String[])new String[0]));
        ElasticSearchHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"install_tarball", (String[])new String[0]));
        ElasticSearchHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)this.getInstallFunction(config, "java", "install_openjdk"), (String[])new String[0]));
        String tarurl = ElasticSearchHandler.prepareRemoteFileUrl((ClusterActionEvent)event, (String)config.getString("whirr.elasticsearch.tarball.url", ""));
        ElasticSearchHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"install_elasticsearch", (String[])new String[]{tarurl}));
    }

    protected void beforeConfigure(ClusterActionEvent event) throws IOException {
        ClusterSpec spec = event.getClusterSpec();
        Cluster cluster = event.getCluster();
        event.getFirewallManager().addRule(FirewallManager.Rule.create().destination(cluster.getInstancesMatching(RolePredicates.role((String)ROLE))).port(9200));
        ElasticSearchHandler.handleFirewallRules((ClusterActionEvent)event);
        Configuration config = ElasticSearchConfigurationBuilder.buildConfig(spec, cluster);
        ElasticSearchHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"retry_helpers", (String[])new String[0]));
        ElasticSearchHandler.addStatement((ClusterActionEvent)event, (Statement)ElasticSearchConfigurationBuilder.build("/tmp/elasticsearch.yml", config));
        ElasticSearchHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"configure_elasticsearch", (String[])config.getStringArray("es.plugins")));
    }

    protected void beforeStart(ClusterActionEvent event) throws IOException {
        ElasticSearchHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"start_elasticsearch", (String[])new String[0]));
    }

    protected void beforeStop(ClusterActionEvent event) throws IOException {
        ElasticSearchHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"stop_elasticsearch", (String[])new String[0]));
    }

    protected void beforeCleanup(ClusterActionEvent event) throws IOException {
        ElasticSearchHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"cleanup_elasticsearch", (String[])new String[0]));
    }
}

