/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wayang.commons.util.profiledb.storage;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.wayang.commons.util.profiledb.ProfileDB;
import org.apache.wayang.commons.util.profiledb.model.Experiment;

public abstract class Storage {
    private URI storageFile;
    private ProfileDB context;

    public Storage(URI uri) {
        this.storageFile = uri;
    }

    public void setContext(ProfileDB context) {
        this.context = context;
    }

    public void changeLocation(URI uri) {
        this.storageFile = uri;
    }

    public abstract void save(Experiment ... var1) throws IOException;

    public abstract void save(Collection<Experiment> var1) throws IOException;

    public abstract void append(Experiment ... var1) throws IOException;

    public abstract void append(Collection<Experiment> var1) throws IOException;

    public abstract Collection<Experiment> load() throws IOException;

    public void save(Collection<Experiment> experiments, OutputStream outputStream) throws IOException {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            this.save(experiments, writer);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unexpectedly, UTF-8 is not supported.");
        }
    }

    public void save(Collection<Experiment> experiments, Writer writer) throws IOException {
        try {
            Gson gson = this.context.getGson();
            for (Experiment experiment : experiments) {
                gson.toJson((Object)experiment, (Appendable)writer);
                writer.append('\n');
            }
            writer.flush();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unexpectedly, UTF-8 is not supported.");
        }
    }

    public Collection<Experiment> load(InputStream inputStream) throws IOException {
        try {
            return this.load(new BufferedReader(new InputStreamReader(inputStream, "UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unexpectedly, UTF-8 is not supported.");
        }
    }

    public Collection<Experiment> load(BufferedReader reader) throws IOException {
        String line;
        LinkedList<Experiment> experiments = new LinkedList<Experiment>();
        Gson gson = this.context.getGson();
        while ((line = reader.readLine()) != null) {
            Experiment experiment = (Experiment)gson.fromJson(line, Experiment.class);
            experiments.add(experiment);
        }
        return experiments;
    }
}

