/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wayang.commons.util.profiledb.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import org.apache.wayang.commons.util.profiledb.model.Experiment;
import org.apache.wayang.commons.util.profiledb.storage.Storage;

public class FileStorage
extends Storage {
    private File file;

    public FileStorage(URI uri) {
        super(uri);
        this.file = new File(uri);
    }

    @Override
    public void changeLocation(URI uri) {
        super.changeLocation(uri);
        this.file = new File(uri);
    }

    @Override
    public void save(Collection<Experiment> experiments) throws IOException {
        this.file.getAbsoluteFile().getParentFile().mkdirs();
        try (FileOutputStream fos = new FileOutputStream(this.file, false);){
            this.save(experiments, fos);
        }
    }

    @Override
    public void save(Experiment ... experiments) throws IOException {
        this.save(Arrays.asList(experiments));
    }

    @Override
    public Collection<Experiment> load() throws IOException {
        return this.load(new FileInputStream(this.file));
    }

    @Override
    public void append(Collection<Experiment> experiments) throws IOException {
        this.file.getAbsoluteFile().getParentFile().mkdirs();
        try (FileOutputStream fos = new FileOutputStream(this.file, true);){
            this.save(experiments, fos);
        }
    }

    @Override
    public void append(Experiment ... experiments) throws IOException {
        this.append(Arrays.asList(experiments));
    }
}

