/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wayang.commons.util.profiledb.model.measurement;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.wayang.commons.util.profiledb.model.Measurement;
import org.apache.wayang.commons.util.profiledb.model.Type;

@Type(value="time")
public class TimeMeasurement
extends Measurement {
    private long millis = 0L;
    private transient long startTime = -1L;
    private Collection<TimeMeasurement> rounds = new LinkedList<TimeMeasurement>();

    private TimeMeasurement() {
    }

    public TimeMeasurement(String id) {
        super(id);
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    private void ensureStarted() {
        if (this.startTime == -1L) {
            this.startTime = System.currentTimeMillis();
        }
    }

    public TimeMeasurement start(String ... identifiers) {
        return this.start(identifiers, 0);
    }

    private TimeMeasurement start(String[] identifiers, int index) {
        if (index >= identifiers.length) {
            this.start();
            return this;
        }
        this.ensureStarted();
        TimeMeasurement round = this.getOrCreateRound(identifiers[index]);
        return round.start(identifiers, index + 1);
    }

    public TimeMeasurement getOrCreateRound(String id) {
        TimeMeasurement round = this.getRound(id);
        if (round != null) {
            return round;
        }
        round = new TimeMeasurement(id);
        this.rounds.add(round);
        return round;
    }

    private TimeMeasurement getRound(String id) {
        for (TimeMeasurement round : this.rounds) {
            if (!id.equals(round.getId())) continue;
            return round;
        }
        return null;
    }

    public void stop() {
        this.stop(System.currentTimeMillis());
    }

    private void stop(long stopTime) {
        if (this.startTime != -1L) {
            this.millis += stopTime - this.startTime;
            this.startTime = -1L;
        }
        for (TimeMeasurement round : this.rounds) {
            round.stop(stopTime);
        }
    }

    public void stop(String ... identfiers) {
        long stopTime = System.currentTimeMillis();
        TimeMeasurement round = this;
        for (String identfier : identfiers) {
            if ((round = round.getRound(identfier)) != null) continue;
            return;
        }
        round.stop(stopTime);
    }

    public long getMillis() {
        return this.millis;
    }

    public void setMillis(long millis) {
        this.millis = millis;
    }

    public Collection<TimeMeasurement> getRounds() {
        return this.rounds;
    }

    public void addRounds(TimeMeasurement round) {
        this.rounds.add(round);
    }

    public static String formatDuration(long millis) {
        if (millis < 0L) {
            return "-" + TimeMeasurement.formatDuration(-millis);
        }
        long ms = millis % 1000L;
        long s = (millis /= 1000L) % 60L;
        long m = (millis /= 60L) % 60L;
        long h = (millis /= 60L) % 60L;
        return String.format("%d:%02d:%02d.%03d", h, m, s, ms);
    }

    public String toString() {
        return String.format("%s[%s, %s, %d subs]", this.getClass().getSimpleName(), this.getId(), TimeMeasurement.formatDuration(this.millis), this.rounds.size());
    }
}

