/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wayang.commons.util.profiledb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import org.apache.wayang.commons.util.profiledb.model.Measurement;
import org.apache.wayang.commons.util.profiledb.model.Subject;

public class Experiment {
    private String id;
    private String description;
    private long startTime;
    private Collection<String> tags;
    private Collection<Measurement> measurements;
    private Subject subject;

    private Experiment() {
    }

    public Experiment(String id, Subject subject, String ... tags) {
        this(id, subject, System.currentTimeMillis(), tags);
    }

    public Experiment(String id, Subject subject, long startTime, String ... tags) {
        this.id = id;
        this.subject = subject;
        this.startTime = startTime;
        this.tags = Arrays.asList(tags);
        this.measurements = new LinkedList<Measurement>();
    }

    public Experiment withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public Collection<String> getTags() {
        return this.tags;
    }

    public void setTags(Collection<String> tags) {
        this.tags = tags;
    }

    public void addMeasurement(Measurement measurement) {
        this.measurements.add(measurement);
    }

    public Collection<Measurement> getMeasurements() {
        return this.measurements;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Experiment that = (Experiment)o;
        return this.startTime == that.startTime && Objects.equals(this.id, that.id) && Objects.equals(this.description, that.description) && Objects.equals(this.tags, that.tags) && Objects.equals(this.subject, that.subject);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.startTime);
    }

    public String toString() {
        return String.format("%s[%s, %d tags, %d measurements]", this.getClass().getSimpleName(), this.id, this.tags.size(), this.measurements.size());
    }
}

