/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wayang.commons.util.profiledb.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.wayang.commons.util.profiledb.model.Measurement;

public class MeasurementDeserializer
implements JsonDeserializer<Measurement> {
    private final Map<String, Class<? extends Measurement>> measurementTypes = new HashMap<String, Class<? extends Measurement>>();

    public void register(Class<? extends Measurement> measurementClass) {
        String typeName = Measurement.getTypeName(measurementClass);
        this.measurementTypes.put(typeName, measurementClass);
    }

    public Measurement deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonElement typeElement = jsonElement.getAsJsonObject().get("type");
        if (typeElement == null) {
            throw new IllegalArgumentException("Missing type in " + jsonElement);
        }
        String typeName = typeElement.getAsString();
        Class<? extends Measurement> measurementClass = this.measurementTypes.get(typeName);
        if (measurementClass == null) {
            throw new JsonParseException("Unknown measurement type: " + typeName);
        }
        return (Measurement)jsonDeserializationContext.deserialize(jsonElement, measurementClass);
    }
}

