/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wayang.commons.util.profiledb.instrumentation;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.wayang.commons.util.profiledb.model.Experiment;
import org.apache.wayang.commons.util.profiledb.model.Measurement;
import org.apache.wayang.commons.util.profiledb.model.measurement.TimeMeasurement;

public class StopWatch {
    private final Map<String, TimeMeasurement> rounds = new LinkedHashMap<String, TimeMeasurement>();
    private final Experiment experiment;

    public StopWatch(Experiment experiment) {
        this.experiment = experiment;
        for (Measurement measurement : this.experiment.getMeasurements()) {
            if (!(measurement instanceof TimeMeasurement)) continue;
            this.rounds.put(measurement.getId(), (TimeMeasurement)measurement);
        }
    }

    public TimeMeasurement getOrCreateRound(String id, String ... furtherIds) {
        TimeMeasurement round = this.rounds.get(id);
        if (round == null) {
            round = new TimeMeasurement(id);
            this.rounds.put(round.getId(), round);
            this.experiment.addMeasurement(round);
        }
        for (String furtherId : furtherIds) {
            round = round.getOrCreateRound(furtherId);
        }
        return round;
    }

    public TimeMeasurement start(String id, String ... furtherIds) {
        return this.getOrCreateRound(id, new String[0]).start(furtherIds);
    }

    public void stop(String id, String ... furtherIds) {
        TimeMeasurement rootRound = this.rounds.get(id);
        if (rootRound != null) {
            rootRound.stop(furtherIds);
        }
    }

    public String toPrettyString() {
        return this.toPrettyString("  ", "* ");
    }

    public String toPrettyString(String indent, String bullet) {
        StringBuilder sb = new StringBuilder(1000);
        int firstColumnWidth = this.determineFirstColumnWidth(this.rounds.values(), indent.length(), 0, bullet.length());
        this.rounds.values().forEach(round -> this.append((TimeMeasurement)round, indent, 0, bullet, firstColumnWidth, sb));
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '\n') {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private int determineFirstColumnWidth(Collection<TimeMeasurement> rounds, int indentWidth, int numIndents, int bulletWidth) {
        return rounds.stream().map(round -> this.determineFirstColumnWidth((TimeMeasurement)round, indentWidth, numIndents, bulletWidth)).reduce(0, Math::max);
    }

    private int determineFirstColumnWidth(TimeMeasurement round, int indentWidth, int numIndents, int bulletWidth) {
        return Math.max(round.getId().length() + numIndents * indentWidth + bulletWidth, this.determineFirstColumnWidth(round.getRounds(), indentWidth, numIndents + 1, bulletWidth));
    }

    private void append(TimeMeasurement round, String indent, int numIndents, String bullet, int firstColumnWidth, StringBuilder sb) {
        int originalLength = sb.length();
        for (int i = 0; i < numIndents; ++i) {
            sb.append(indent);
        }
        sb.append(bullet).append(round.getId());
        while (sb.length() < originalLength + firstColumnWidth) {
            sb.append(" ");
        }
        sb.append(" - ").append(TimeMeasurement.formatDuration(round.getMillis())).append('\n');
        round.getRounds().forEach(subround -> this.append((TimeMeasurement)subround, indent, numIndents + 1, bullet, firstColumnWidth, sb));
    }

    public void stopAll() {
        this.rounds.values().forEach(TimeMeasurement::stop);
    }

    public Experiment getExperiment() {
        return this.experiment;
    }
}

