/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wayang.commons.util.profiledb;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.wayang.commons.util.profiledb.json.MeasurementDeserializer;
import org.apache.wayang.commons.util.profiledb.json.MeasurementSerializer;
import org.apache.wayang.commons.util.profiledb.model.Experiment;
import org.apache.wayang.commons.util.profiledb.model.Measurement;
import org.apache.wayang.commons.util.profiledb.storage.Storage;

public class ProfileDB {
    private List<Class<? extends Measurement>> measurementClasses = new LinkedList<Class<? extends Measurement>>();
    private Storage storage;
    private List<Consumer<GsonBuilder>> gsonPreparationSteps = new LinkedList<Consumer<GsonBuilder>>();
    private Gson gson;

    public void save(Experiment ... experiments) throws IOException {
        this.storage.save(experiments);
    }

    public void save(Collection<Experiment> experiments) throws IOException {
        this.storage.save(experiments);
    }

    public void save(Collection<Experiment> experiments, OutputStream outputStream) throws IOException {
        this.storage.save(experiments, outputStream);
    }

    public void append(Experiment ... experiments) throws IOException {
        this.storage.append(experiments);
    }

    public void append(Collection<Experiment> experiments) throws IOException {
        this.storage.append(experiments);
    }

    public Collection<Experiment> load() throws IOException {
        return this.storage.load();
    }

    public Collection<Experiment> load(InputStream inputStream) throws IOException {
        return this.storage.load(inputStream);
    }

    public ProfileDB(Storage storage) {
        this.storage = storage;
        this.storage.setContext(this);
    }

    public Storage getStorage() {
        return this.storage;
    }

    public ProfileDB registerMeasurementClass(Class<? extends Measurement> measurementClass) {
        this.measurementClasses.add(measurementClass);
        this.gson = null;
        return this;
    }

    public ProfileDB withGsonPreparation(Consumer<GsonBuilder> preparation) {
        this.gsonPreparationSteps.add(preparation);
        this.gson = null;
        return this;
    }

    public Gson getGson() {
        if (this.gson == null) {
            MeasurementSerializer measurementSerializer = new MeasurementSerializer();
            MeasurementDeserializer measurementDeserializer = new MeasurementDeserializer();
            this.measurementClasses.forEach(measurementDeserializer::register);
            GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(Measurement.class, (Object)measurementDeserializer).registerTypeAdapter(Measurement.class, (Object)measurementSerializer);
            this.gsonPreparationSteps.forEach(step -> step.accept(gsonBuilder));
            this.gson = gsonBuilder.create();
        }
        return this.gson;
    }
}

