/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wayang.tensorflow.platform;

import org.apache.wayang.core.api.Configuration;
import org.apache.wayang.core.api.Job;
import org.apache.wayang.core.optimizer.costs.LoadProfileToTimeConverter;
import org.apache.wayang.core.optimizer.costs.LoadToTimeConverter;
import org.apache.wayang.core.optimizer.costs.TimeToCostConverter;
import org.apache.wayang.core.platform.Executor;
import org.apache.wayang.core.platform.Platform;
import org.apache.wayang.core.util.ReflectionUtils;
import org.apache.wayang.tensorflow.execution.TensorflowContextReference;
import org.apache.wayang.tensorflow.execution.TensorflowExecutor;

public class TensorflowPlatform
extends Platform {
    private static final String PLATFORM_NAME = "Tensorflow";
    private static final String CONFIG_NAME = "tensorflow";
    private static final String DEFAULT_CONFIG_FILE = "wayang-tensorflow-defaults.properties";
    private static TensorflowPlatform instance = null;
    private TensorflowContextReference tensorflowContextReference;

    public static TensorflowPlatform getInstance() {
        if (instance == null) {
            instance = new TensorflowPlatform();
        }
        return instance;
    }

    private TensorflowPlatform() {
        super(PLATFORM_NAME, CONFIG_NAME);
    }

    protected void configureDefaults(Configuration configuration) {
        configuration.load(ReflectionUtils.loadResource((String)DEFAULT_CONFIG_FILE));
    }

    public Executor.Factory getExecutorFactory() {
        return job -> new TensorflowExecutor(this, job);
    }

    public LoadProfileToTimeConverter createLoadProfileToTimeConverter(Configuration configuration) {
        int cpuMhz = (int)configuration.getLongProperty("wayang.tensorflow.cpu.mhz");
        int numCores = (int)configuration.getLongProperty("wayang.tensorflow.cores");
        double hdfsMsPerMb = configuration.getDoubleProperty("wayang.tensorflow.hdfs.ms-per-mb");
        return LoadProfileToTimeConverter.createDefault((LoadToTimeConverter)LoadToTimeConverter.createLinearCoverter((double)(1.0 / ((double)(numCores * cpuMhz) * 1000.0))), (LoadToTimeConverter)LoadToTimeConverter.createLinearCoverter((double)(hdfsMsPerMb / 1000000.0)), (LoadToTimeConverter)LoadToTimeConverter.createLinearCoverter((double)0.0), (cpuEstimate, diskEstimate, networkEstimate) -> cpuEstimate.plus(diskEstimate).plus(networkEstimate));
    }

    public TimeToCostConverter createTimeToCostConverter(Configuration configuration) {
        return new TimeToCostConverter(configuration.getDoubleProperty("wayang.tensorflow.costs.fix"), configuration.getDoubleProperty("wayang.tensorflow.costs.per-ms"));
    }

    public TensorflowContextReference getTensorflowContext(Job job) {
        if (this.tensorflowContextReference == null || this.tensorflowContextReference.isDisposed()) {
            this.tensorflowContextReference = new TensorflowContextReference(job.getCrossPlatformExecutor());
        }
        return this.tensorflowContextReference;
    }
}

