/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wayang.tensorflow.operators;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.wayang.basic.operators.CollectionSource;
import org.apache.wayang.core.optimizer.OptimizationContext;
import org.apache.wayang.core.plan.wayangplan.ExecutionOperator;
import org.apache.wayang.core.platform.ChannelDescriptor;
import org.apache.wayang.core.platform.ChannelInstance;
import org.apache.wayang.core.platform.lineage.ExecutionLineageNode;
import org.apache.wayang.core.types.DataSetType;
import org.apache.wayang.core.util.Tuple;
import org.apache.wayang.core.util.WayangCollections;
import org.apache.wayang.java.channels.CollectionChannel;
import org.apache.wayang.tensorflow.channels.TensorChannel;
import org.apache.wayang.tensorflow.execution.TensorflowExecutor;
import org.apache.wayang.tensorflow.operators.TensorflowExecutionOperator;
import org.tensorflow.ndarray.IntNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.StdArrays;

public class TensorflowCollectionSource<Type>
extends CollectionSource<Type>
implements TensorflowExecutionOperator {
    public TensorflowCollectionSource(DataSetType<Type> type) {
        this(null, type);
    }

    public TensorflowCollectionSource(Collection<Type> collection, DataSetType<Type> type) {
        super(collection, type);
    }

    public TensorflowCollectionSource(CollectionSource that) {
        super(that);
    }

    protected ExecutionOperator createCopy() {
        return new TensorflowCollectionSource<Type>(this.getCollection(), this.getType());
    }

    public List<ChannelDescriptor> getSupportedInputChannels(int index) {
        return Collections.singletonList(CollectionChannel.DESCRIPTOR);
    }

    public List<ChannelDescriptor> getSupportedOutputChannels(int index) {
        return Collections.singletonList(TensorChannel.DESCRIPTOR);
    }

    @Override
    public Tuple<Collection<ExecutionLineageNode>, Collection<ChannelInstance>> evaluate(ChannelInstance[] inputs, ChannelInstance[] outputs, TensorflowExecutor tensorflowExecutor, OptimizationContext.OperatorContext operatorContext) {
        IntNdArray ndArray;
        Collection collection;
        assert (inputs.length <= 1);
        assert (outputs.length == this.getNumOutputs());
        if (this.collection != null) {
            collection = this.collection;
        } else {
            CollectionChannel.Instance input = (CollectionChannel.Instance)inputs[0];
            collection = input.provideCollection();
            assert (collection != null) : String.format("Instance of %s is not providing a collection.", input.getChannel());
        }
        assert (collection.size() > 0) : "Collection is empty";
        List list = WayangCollections.asList((Collection)collection);
        Object e = list.get(0);
        if (e instanceof Integer) {
            ndArray = StdArrays.ndCopyOf((int[])list.stream().mapToInt(o -> (Integer)o).toArray());
        } else if (e instanceof int[]) {
            ndArray = StdArrays.ndCopyOf((int[][])((int[][])list.toArray((T[])new int[0][])));
        } else if (e instanceof int[][]) {
            ndArray = StdArrays.ndCopyOf((int[][][])((int[][][])list.toArray((T[])new int[0][][])));
        } else if (e instanceof int[][][]) {
            ndArray = StdArrays.ndCopyOf((int[][][][])((int[][][][])list.toArray((T[])new int[0][][][])));
        } else if (e instanceof int[][][][]) {
            ndArray = StdArrays.ndCopyOf((int[][][][][])((int[][][][][])list.toArray((T[])new int[0][][][][])));
        } else if (e instanceof int[][][][][]) {
            ndArray = StdArrays.ndCopyOf((int[][][][][][])((int[][][][][][])list.toArray((T[])new int[0][][][][][])));
        } else if (e instanceof Long) {
            ndArray = StdArrays.ndCopyOf((long[])list.stream().mapToLong(o -> (Long)o).toArray());
        } else if (e instanceof long[]) {
            ndArray = StdArrays.ndCopyOf((long[][])((long[][])list.toArray((T[])new long[0][])));
        } else if (e instanceof long[][]) {
            ndArray = StdArrays.ndCopyOf((long[][][])((long[][][])list.toArray((T[])new long[0][][])));
        } else if (e instanceof long[][][]) {
            ndArray = StdArrays.ndCopyOf((long[][][][])((long[][][][])list.toArray((T[])new long[0][][][])));
        } else if (e instanceof long[][][][]) {
            ndArray = StdArrays.ndCopyOf((long[][][][][])((long[][][][][])list.toArray((T[])new long[0][][][][])));
        } else if (e instanceof long[][][][][]) {
            ndArray = StdArrays.ndCopyOf((long[][][][][][])((long[][][][][][])list.toArray((T[])new long[0][][][][][])));
        } else if (e instanceof Float) {
            float[] floats = new float[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                floats[i] = ((Float)list.get(i)).floatValue();
            }
            ndArray = StdArrays.ndCopyOf((float[])floats);
        } else if (e instanceof float[]) {
            ndArray = StdArrays.ndCopyOf((float[][])((float[][])list.toArray((T[])new float[0][])));
        } else if (e instanceof float[][]) {
            ndArray = StdArrays.ndCopyOf((float[][][])((float[][][])list.toArray((T[])new float[0][][])));
        } else if (e instanceof float[][][]) {
            ndArray = StdArrays.ndCopyOf((float[][][][])((float[][][][])list.toArray((T[])new float[0][][][])));
        } else if (e instanceof float[][][][]) {
            ndArray = StdArrays.ndCopyOf((float[][][][][])((float[][][][][])list.toArray((T[])new float[0][][][][])));
        } else if (e instanceof float[][][][][]) {
            ndArray = StdArrays.ndCopyOf((float[][][][][][])((float[][][][][][])list.toArray((T[])new float[0][][][][][])));
        } else if (e instanceof Double) {
            ndArray = StdArrays.ndCopyOf((double[])list.stream().mapToDouble(o -> (Double)o).toArray());
        } else if (e instanceof double[]) {
            ndArray = StdArrays.ndCopyOf((double[][])((double[][])list.toArray((T[])new double[0][])));
        } else if (e instanceof double[][]) {
            ndArray = StdArrays.ndCopyOf((double[][][])((double[][][])list.toArray((T[])new double[0][][])));
        } else if (e instanceof double[][][]) {
            ndArray = StdArrays.ndCopyOf((double[][][][])((double[][][][])list.toArray((T[])new double[0][][][])));
        } else if (e instanceof double[][][][]) {
            ndArray = StdArrays.ndCopyOf((double[][][][][])((double[][][][][])list.toArray((T[])new double[0][][][][])));
        } else if (e instanceof double[][][][][]) {
            ndArray = StdArrays.ndCopyOf((double[][][][][][])((double[][][][][][])list.toArray((T[])new double[0][][][][][])));
        } else if (e instanceof Byte) {
            byte[] bytes = new byte[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                bytes[i] = (Byte)list.get(i);
            }
            ndArray = StdArrays.ndCopyOf((byte[])bytes);
        } else if (e instanceof byte[]) {
            ndArray = StdArrays.ndCopyOf((byte[][])((byte[][])list.toArray((T[])new byte[0][])));
        } else if (e instanceof byte[][]) {
            ndArray = StdArrays.ndCopyOf((byte[][][])((byte[][][])list.toArray((T[])new byte[0][][])));
        } else if (e instanceof byte[][][]) {
            ndArray = StdArrays.ndCopyOf((byte[][][][])((byte[][][][])list.toArray((T[])new byte[0][][][])));
        } else if (e instanceof byte[][][][]) {
            ndArray = StdArrays.ndCopyOf((byte[][][][][])((byte[][][][][])list.toArray((T[])new byte[0][][][][])));
        } else if (e instanceof byte[][][][][]) {
            ndArray = StdArrays.ndCopyOf((byte[][][][][][])((byte[][][][][][])list.toArray((T[])new byte[0][][][][][])));
        } else if (e instanceof Short) {
            short[] shorts = new short[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                shorts[i] = (Short)list.get(i);
            }
            ndArray = StdArrays.ndCopyOf((short[])shorts);
        } else if (e instanceof short[]) {
            ndArray = StdArrays.ndCopyOf((short[][])((short[][])list.toArray((T[])new short[0][])));
        } else if (e instanceof short[][]) {
            ndArray = StdArrays.ndCopyOf((short[][][])((short[][][])list.toArray((T[])new short[0][][])));
        } else if (e instanceof short[][][]) {
            ndArray = StdArrays.ndCopyOf((short[][][][])((short[][][][])list.toArray((T[])new short[0][][][])));
        } else if (e instanceof short[][][][]) {
            ndArray = StdArrays.ndCopyOf((short[][][][][])((short[][][][][])list.toArray((T[])new short[0][][][][])));
        } else if (e instanceof short[][][][][]) {
            ndArray = StdArrays.ndCopyOf((short[][][][][][])((short[][][][][][])list.toArray((T[])new short[0][][][][][])));
        } else if (e instanceof Boolean) {
            boolean[] booleans = new boolean[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                booleans[i] = (Boolean)list.get(i);
            }
            ndArray = StdArrays.ndCopyOf((boolean[])booleans);
        } else if (e instanceof boolean[]) {
            ndArray = StdArrays.ndCopyOf((boolean[][])((boolean[][])list.toArray((T[])new boolean[0][])));
        } else if (e instanceof boolean[][]) {
            ndArray = StdArrays.ndCopyOf((boolean[][][])((boolean[][][])list.toArray((T[])new boolean[0][][])));
        } else if (e instanceof boolean[][][]) {
            ndArray = StdArrays.ndCopyOf((boolean[][][][])((boolean[][][][])list.toArray((T[])new boolean[0][][][])));
        } else if (e instanceof boolean[][][][]) {
            ndArray = StdArrays.ndCopyOf((boolean[][][][][])((boolean[][][][][])list.toArray((T[])new boolean[0][][][][])));
        } else if (e instanceof boolean[][][][][]) {
            ndArray = StdArrays.ndCopyOf((boolean[][][][][][])((boolean[][][][][][])list.toArray((T[])new boolean[0][][][][][])));
        } else if (e instanceof String) {
            ndArray = StdArrays.ndCopyOf((Object[])list.stream().toArray());
        } else {
            throw new RuntimeException("Unsupported element type: " + e.getClass().getName() + "; expected: " + String.valueOf(this.getType()));
        }
        TensorChannel.Instance output = (TensorChannel.Instance)outputs[0];
        output.accept((NdArray<?>)ndArray);
        return ExecutionOperator.modelEagerExecution((ChannelInstance[])inputs, (ChannelInstance[])outputs, (OptimizationContext.OperatorContext)operatorContext);
    }
}

