/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wayang.tensorflow.operators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.wayang.core.optimizer.OptimizationContext;
import org.apache.wayang.core.plan.wayangplan.ExecutionOperator;
import org.apache.wayang.core.plan.wayangplan.UnaryToUnaryOperator;
import org.apache.wayang.core.platform.ChannelDescriptor;
import org.apache.wayang.core.platform.ChannelInstance;
import org.apache.wayang.core.platform.lineage.ExecutionLineageNode;
import org.apache.wayang.core.types.DataSetType;
import org.apache.wayang.core.util.Tuple;
import org.apache.wayang.java.channels.CollectionChannel;
import org.apache.wayang.tensorflow.channels.TensorChannel;
import org.apache.wayang.tensorflow.execution.TensorflowExecutor;
import org.apache.wayang.tensorflow.operators.TensorflowExecutionOperator;
import org.tensorflow.ndarray.BooleanNdArray;
import org.tensorflow.ndarray.ByteNdArray;
import org.tensorflow.ndarray.DoubleNdArray;
import org.tensorflow.ndarray.FloatNdArray;
import org.tensorflow.ndarray.IntNdArray;
import org.tensorflow.ndarray.LongNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.ShortNdArray;
import org.tensorflow.ndarray.StdArrays;

public class TensorflowCollectOperator<Type>
extends UnaryToUnaryOperator<NdArray, Type>
implements TensorflowExecutionOperator {
    public TensorflowCollectOperator(DataSetType<Type> type) {
        super(DataSetType.createDefaultUnchecked(NdArray.class), type, false);
    }

    public List<ChannelDescriptor> getSupportedInputChannels(int index) {
        return Collections.singletonList(TensorChannel.DESCRIPTOR);
    }

    public List<ChannelDescriptor> getSupportedOutputChannels(int index) {
        return Collections.singletonList(CollectionChannel.DESCRIPTOR);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Tuple<Collection<ExecutionLineageNode>, Collection<ChannelInstance>> evaluate(ChannelInstance[] inputs, ChannelInstance[] outputs, TensorflowExecutor tensorflowExecutor, OptimizationContext.OperatorContext operatorContext) {
        List list;
        assert (inputs.length == this.getNumInputs());
        assert (outputs.length == this.getNumOutputs());
        TensorChannel.Instance input = (TensorChannel.Instance)inputs[0];
        CollectionChannel.Instance output = (CollectionChannel.Instance)outputs[0];
        Object ndArray = input.provideTensor();
        long[] shape = ndArray.shape().asArray();
        if (shape.length == 1) {
            if (ndArray instanceof IntNdArray) {
                int[] dst = new int[(int)shape[0]];
                StdArrays.copyFrom((IntNdArray)((IntNdArray)ndArray), (int[])dst);
                list = Arrays.stream(dst).boxed().collect(Collectors.toList());
            } else if (ndArray instanceof LongNdArray) {
                long[] dst = new long[(int)shape[0]];
                StdArrays.copyFrom((LongNdArray)((LongNdArray)ndArray), (long[])dst);
                list = Arrays.stream(dst).boxed().collect(Collectors.toList());
            } else if (ndArray instanceof FloatNdArray) {
                float[] dst = new float[(int)shape[0]];
                StdArrays.copyFrom((FloatNdArray)((FloatNdArray)ndArray), (float[])dst);
                list = new ArrayList((int)shape[0]);
                for (float v : dst) {
                    list.add(Float.valueOf(v));
                }
            } else if (ndArray instanceof DoubleNdArray) {
                double[] dst = new double[(int)shape[0]];
                StdArrays.copyFrom((DoubleNdArray)((DoubleNdArray)ndArray), (double[])dst);
                list = Arrays.stream(dst).boxed().collect(Collectors.toList());
            } else if (ndArray instanceof ShortNdArray) {
                short[] dst = new short[(int)shape[0]];
                StdArrays.copyFrom((ShortNdArray)((ShortNdArray)ndArray), (short[])dst);
                list = new ArrayList((int)shape[0]);
                for (short value : dst) {
                    list.add(value);
                }
            } else if (ndArray instanceof ByteNdArray) {
                byte[] dst = new byte[(int)shape[0]];
                StdArrays.copyFrom((ByteNdArray)((ByteNdArray)ndArray), (byte[])dst);
                list = new ArrayList((int)shape[0]);
                for (byte b : dst) {
                    list.add(b);
                }
            } else {
                if (!(ndArray instanceof BooleanNdArray)) throw new RuntimeException("Unsupported NdArray type.");
                boolean[] dst = new boolean[(int)shape[0]];
                StdArrays.copyFrom((BooleanNdArray)((BooleanNdArray)ndArray), (boolean[])dst);
                list = new ArrayList((int)shape[0]);
                for (boolean b : dst) {
                    list.add(b);
                }
            }
        } else if (shape.length == 2) {
            if (ndArray instanceof IntNdArray) {
                int[][] dst = new int[(int)shape[0]][(int)shape[1]];
                StdArrays.copyFrom((IntNdArray)((IntNdArray)ndArray), (int[][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            } else if (ndArray instanceof LongNdArray) {
                long[][] dst = new long[(int)shape[0]][(int)shape[1]];
                StdArrays.copyFrom((LongNdArray)((LongNdArray)ndArray), (long[][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            } else if (ndArray instanceof FloatNdArray) {
                float[][] dst = new float[(int)shape[0]][(int)shape[1]];
                StdArrays.copyFrom((FloatNdArray)((FloatNdArray)ndArray), (float[][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            } else if (ndArray instanceof DoubleNdArray) {
                double[][] dst = new double[(int)shape[0]][(int)shape[1]];
                StdArrays.copyFrom((DoubleNdArray)((DoubleNdArray)ndArray), (double[][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            } else if (ndArray instanceof ShortNdArray) {
                short[][] dst = new short[(int)shape[0]][(int)shape[1]];
                StdArrays.copyFrom((ShortNdArray)((ShortNdArray)ndArray), (short[][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            } else if (ndArray instanceof ByteNdArray) {
                byte[][] dst = new byte[(int)shape[0]][(int)shape[1]];
                StdArrays.copyFrom((ByteNdArray)((ByteNdArray)ndArray), (byte[][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            } else {
                if (!(ndArray instanceof BooleanNdArray)) throw new RuntimeException("Unsupported NdArray type.");
                boolean[][] dst = new boolean[(int)shape[0]][(int)shape[1]];
                StdArrays.copyFrom((BooleanNdArray)((BooleanNdArray)ndArray), (boolean[][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            }
        } else if (shape.length == 3) {
            if (ndArray instanceof IntNdArray) {
                int[][][] dst = new int[(int)shape[0]][(int)shape[1]][(int)shape[2]];
                StdArrays.copyFrom((IntNdArray)((IntNdArray)ndArray), (int[][][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            } else if (ndArray instanceof LongNdArray) {
                long[][][] dst = new long[(int)shape[0]][(int)shape[1]][(int)shape[2]];
                StdArrays.copyFrom((LongNdArray)((LongNdArray)ndArray), (long[][][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            } else if (ndArray instanceof FloatNdArray) {
                float[][][] dst = new float[(int)shape[0]][(int)shape[1]][(int)shape[2]];
                StdArrays.copyFrom((FloatNdArray)((FloatNdArray)ndArray), (float[][][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            } else if (ndArray instanceof DoubleNdArray) {
                double[][][] dst = new double[(int)shape[0]][(int)shape[1]][(int)shape[2]];
                StdArrays.copyFrom((DoubleNdArray)((DoubleNdArray)ndArray), (double[][][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            } else if (ndArray instanceof ShortNdArray) {
                short[][][] dst = new short[(int)shape[0]][(int)shape[1]][(int)shape[2]];
                StdArrays.copyFrom((ShortNdArray)((ShortNdArray)ndArray), (short[][][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            } else if (ndArray instanceof ByteNdArray) {
                byte[][][] dst = new byte[(int)shape[0]][(int)shape[1]][(int)shape[2]];
                StdArrays.copyFrom((ByteNdArray)((ByteNdArray)ndArray), (byte[][][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            } else {
                if (!(ndArray instanceof BooleanNdArray)) throw new RuntimeException("Unsupported NdArray type.");
                boolean[][][] dst = new boolean[(int)shape[0]][(int)shape[1]][(int)shape[2]];
                StdArrays.copyFrom((BooleanNdArray)((BooleanNdArray)ndArray), (boolean[][][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            }
        } else if (shape.length == 4) {
            if (ndArray instanceof IntNdArray) {
                int[][][][] dst = new int[(int)shape[0]][(int)shape[1]][(int)shape[2]][(int)shape[3]];
                StdArrays.copyFrom((IntNdArray)((IntNdArray)ndArray), (int[][][][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            } else if (ndArray instanceof LongNdArray) {
                long[][][][] dst = new long[(int)shape[0]][(int)shape[1]][(int)shape[2]][(int)shape[3]];
                StdArrays.copyFrom((LongNdArray)((LongNdArray)ndArray), (long[][][][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            } else if (ndArray instanceof FloatNdArray) {
                float[][][][] dst = new float[(int)shape[0]][(int)shape[1]][(int)shape[2]][(int)shape[3]];
                StdArrays.copyFrom((FloatNdArray)((FloatNdArray)ndArray), (float[][][][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            } else if (ndArray instanceof DoubleNdArray) {
                double[][][][] dst = new double[(int)shape[0]][(int)shape[1]][(int)shape[2]][(int)shape[3]];
                StdArrays.copyFrom((DoubleNdArray)((DoubleNdArray)ndArray), (double[][][][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            } else if (ndArray instanceof ShortNdArray) {
                short[][][][] dst = new short[(int)shape[0]][(int)shape[1]][(int)shape[2]][(int)shape[3]];
                StdArrays.copyFrom((ShortNdArray)((ShortNdArray)ndArray), (short[][][][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            } else if (ndArray instanceof ByteNdArray) {
                byte[][][][] dst = new byte[(int)shape[0]][(int)shape[1]][(int)shape[2]][(int)shape[3]];
                StdArrays.copyFrom((ByteNdArray)((ByteNdArray)ndArray), (byte[][][][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            } else {
                if (!(ndArray instanceof BooleanNdArray)) throw new RuntimeException("Unsupported NdArray type.");
                boolean[][][][] dst = new boolean[(int)shape[0]][(int)shape[1]][(int)shape[2]][(int)shape[3]];
                StdArrays.copyFrom((BooleanNdArray)((BooleanNdArray)ndArray), (boolean[][][][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            }
        } else if (shape.length == 5) {
            if (ndArray instanceof IntNdArray) {
                int[][][][][] dst = new int[(int)shape[0]][(int)shape[1]][(int)shape[2]][(int)shape[3]][(int)shape[4]];
                StdArrays.copyFrom((IntNdArray)((IntNdArray)ndArray), (int[][][][][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            } else if (ndArray instanceof LongNdArray) {
                long[][][][][] dst = new long[(int)shape[0]][(int)shape[1]][(int)shape[2]][(int)shape[3]][(int)shape[4]];
                StdArrays.copyFrom((LongNdArray)((LongNdArray)ndArray), (long[][][][][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            } else if (ndArray instanceof FloatNdArray) {
                float[][][][][] dst = new float[(int)shape[0]][(int)shape[1]][(int)shape[2]][(int)shape[3]][(int)shape[4]];
                StdArrays.copyFrom((FloatNdArray)((FloatNdArray)ndArray), (float[][][][][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            } else if (ndArray instanceof DoubleNdArray) {
                double[][][][][] dst = new double[(int)shape[0]][(int)shape[1]][(int)shape[2]][(int)shape[3]][(int)shape[4]];
                StdArrays.copyFrom((DoubleNdArray)((DoubleNdArray)ndArray), (double[][][][][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            } else if (ndArray instanceof ShortNdArray) {
                short[][][][][] dst = new short[(int)shape[0]][(int)shape[1]][(int)shape[2]][(int)shape[3]][(int)shape[4]];
                StdArrays.copyFrom((ShortNdArray)((ShortNdArray)ndArray), (short[][][][][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            } else if (ndArray instanceof ByteNdArray) {
                byte[][][][][] dst = new byte[(int)shape[0]][(int)shape[1]][(int)shape[2]][(int)shape[3]][(int)shape[4]];
                StdArrays.copyFrom((ByteNdArray)((ByteNdArray)ndArray), (byte[][][][][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            } else {
                if (!(ndArray instanceof BooleanNdArray)) throw new RuntimeException("Unsupported NdArray type.");
                boolean[][][][][] dst = new boolean[(int)shape[0]][(int)shape[1]][(int)shape[2]][(int)shape[3]][(int)shape[4]];
                StdArrays.copyFrom((BooleanNdArray)((BooleanNdArray)ndArray), (boolean[][][][][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            }
        } else {
            if (shape.length != 6) throw new RuntimeException(String.format("Unsupported shape: %s.", Arrays.toString(shape)));
            if (ndArray instanceof IntNdArray) {
                int[][][][][][] dst = new int[(int)shape[0]][(int)shape[1]][(int)shape[2]][(int)shape[3]][(int)shape[4]][(int)shape[5]];
                StdArrays.copyFrom((IntNdArray)((IntNdArray)ndArray), (int[][][][][][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            } else if (ndArray instanceof LongNdArray) {
                long[][][][][][] dst = new long[(int)shape[0]][(int)shape[1]][(int)shape[2]][(int)shape[3]][(int)shape[4]][(int)shape[5]];
                StdArrays.copyFrom((LongNdArray)((LongNdArray)ndArray), (long[][][][][][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            } else if (ndArray instanceof FloatNdArray) {
                float[][][][][][] dst = new float[(int)shape[0]][(int)shape[1]][(int)shape[2]][(int)shape[3]][(int)shape[4]][(int)shape[5]];
                StdArrays.copyFrom((FloatNdArray)((FloatNdArray)ndArray), (float[][][][][][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            } else if (ndArray instanceof DoubleNdArray) {
                double[][][][][][] dst = new double[(int)shape[0]][(int)shape[1]][(int)shape[2]][(int)shape[3]][(int)shape[4]][(int)shape[5]];
                StdArrays.copyFrom((DoubleNdArray)((DoubleNdArray)ndArray), (double[][][][][][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            } else if (ndArray instanceof ShortNdArray) {
                short[][][][][][] dst = new short[(int)shape[0]][(int)shape[1]][(int)shape[2]][(int)shape[3]][(int)shape[4]][(int)shape[5]];
                StdArrays.copyFrom((ShortNdArray)((ShortNdArray)ndArray), (short[][][][][][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            } else if (ndArray instanceof ByteNdArray) {
                byte[][][][][][] dst = new byte[(int)shape[0]][(int)shape[1]][(int)shape[2]][(int)shape[3]][(int)shape[4]][(int)shape[5]];
                StdArrays.copyFrom((ByteNdArray)((ByteNdArray)ndArray), (byte[][][][][][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            } else {
                if (!(ndArray instanceof BooleanNdArray)) throw new RuntimeException("Unsupported NdArray type.");
                boolean[][][][][][] dst = new boolean[(int)shape[0]][(int)shape[1]][(int)shape[2]][(int)shape[3]][(int)shape[4]][(int)shape[5]];
                StdArrays.copyFrom((BooleanNdArray)((BooleanNdArray)ndArray), (boolean[][][][][][])dst);
                list = Arrays.stream(dst).collect(Collectors.toList());
            }
        }
        output.accept(list);
        return ExecutionOperator.modelEagerExecution((ChannelInstance[])inputs, (ChannelInstance[])outputs, (OptimizationContext.OperatorContext)operatorContext);
    }
}

