/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wayang.graphchi.platform;

import edu.cmu.graphchi.io.CompressedIO;
import org.apache.wayang.core.api.Configuration;
import org.apache.wayang.core.optimizer.costs.LoadProfileToTimeConverter;
import org.apache.wayang.core.optimizer.costs.LoadToTimeConverter;
import org.apache.wayang.core.optimizer.costs.TimeToCostConverter;
import org.apache.wayang.core.platform.Executor;
import org.apache.wayang.core.platform.Platform;
import org.apache.wayang.core.util.ReflectionUtils;
import org.apache.wayang.graphchi.execution.GraphChiExecutor;

public class GraphChiPlatform
extends Platform {
    public static final String CPU_MHZ_PROPERTY = "wayang.graphchi.cpu.mhz";
    public static final String CORES_PROPERTY = "wayang.graphchi.cores";
    public static final String HDFS_MS_PER_MB_PROPERTY = "wayang.graphchi.hdfs.ms-per-mb";
    private static final String DEFAULT_CONFIG_FILE = "wayang-graphchi-defaults.properties";
    private static GraphChiPlatform instance;

    protected GraphChiPlatform() {
        super("GraphChi", "graphchi");
        this.initialize();
    }

    private void initialize() {
        CompressedIO.disableCompression();
        GraphChiPlatform.class.getClassLoader().setClassAssertionStatus("edu.cmu.graphchi.preprocessing.FastSharder", false);
    }

    public void configureDefaults(Configuration configuration) {
        configuration.load(ReflectionUtils.loadResource((String)DEFAULT_CONFIG_FILE));
    }

    public static GraphChiPlatform getInstance() {
        if (instance == null) {
            instance = new GraphChiPlatform();
        }
        return instance;
    }

    public Executor.Factory getExecutorFactory() {
        return job -> new GraphChiExecutor(this, job);
    }

    public LoadProfileToTimeConverter createLoadProfileToTimeConverter(Configuration configuration) {
        int cpuMhz = (int)configuration.getLongProperty(CPU_MHZ_PROPERTY);
        int numCores = (int)configuration.getLongProperty(CORES_PROPERTY);
        double hdfsMsPerMb = configuration.getDoubleProperty(HDFS_MS_PER_MB_PROPERTY);
        return LoadProfileToTimeConverter.createDefault((LoadToTimeConverter)LoadToTimeConverter.createLinearCoverter((double)(1.0 / ((double)(numCores * cpuMhz) * 1000.0))), (LoadToTimeConverter)LoadToTimeConverter.createLinearCoverter((double)(hdfsMsPerMb / 1000000.0)), (LoadToTimeConverter)LoadToTimeConverter.createLinearCoverter((double)0.0), (cpuEstimate, diskEstimate, networkEstimate) -> cpuEstimate.plus(diskEstimate).plus(networkEstimate));
    }

    public TimeToCostConverter createTimeToCostConverter(Configuration configuration) {
        return new TimeToCostConverter(configuration.getDoubleProperty("wayang.graphchi.costs.fix"), configuration.getDoubleProperty("wayang.graphchi.costs.per-ms"));
    }
}

