/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.comm.channels;

import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.net.buffers.IBufferAcceptor;
import edu.uci.ics.hyracks.net.protocols.muxdemux.ChannelControlBlock;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;

public class NetworkOutputChannel
implements IFrameWriter {
    private final ChannelControlBlock ccb;
    private final int nBuffers;
    private final Deque<ByteBuffer> emptyStack;
    private boolean aborted;

    public NetworkOutputChannel(ChannelControlBlock ccb, int nBuffers) {
        this.ccb = ccb;
        this.nBuffers = nBuffers;
        this.emptyStack = new ArrayDeque<ByteBuffer>(nBuffers);
        ccb.getWriteInterface().setEmptyBufferAcceptor((IBufferAcceptor)new WriteEmptyBufferAcceptor());
    }

    public void setFrameSize(int frameSize) {
        for (int i = 0; i < this.nBuffers; ++i) {
            this.emptyStack.push(ByteBuffer.allocateDirect(frameSize));
        }
    }

    public void open() throws HyracksDataException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        ByteBuffer destBuffer = null;
        NetworkOutputChannel networkOutputChannel = this;
        synchronized (networkOutputChannel) {
            while (true) {
                if (this.aborted) {
                    throw new HyracksDataException("Connection has been aborted");
                }
                destBuffer = this.emptyStack.poll();
                if (destBuffer != null) break;
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
        }
        buffer.position(0);
        buffer.limit(destBuffer.capacity());
        destBuffer.clear();
        destBuffer.put(buffer);
        destBuffer.flip();
        this.ccb.getWriteInterface().getFullBufferAcceptor().accept(destBuffer);
    }

    public void fail() throws HyracksDataException {
        this.ccb.getWriteInterface().getFullBufferAcceptor().error(1);
    }

    public void close() throws HyracksDataException {
        this.ccb.getWriteInterface().getFullBufferAcceptor().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        this.ccb.getWriteInterface().getFullBufferAcceptor().error(1);
        NetworkOutputChannel networkOutputChannel = this;
        synchronized (networkOutputChannel) {
            this.aborted = true;
            this.notifyAll();
        }
    }

    private class WriteEmptyBufferAcceptor
    implements IBufferAcceptor {
        private WriteEmptyBufferAcceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void accept(ByteBuffer buffer) {
            NetworkOutputChannel networkOutputChannel = NetworkOutputChannel.this;
            synchronized (networkOutputChannel) {
                NetworkOutputChannel.this.emptyStack.push(buffer);
                NetworkOutputChannel.this.notifyAll();
            }
        }
    }
}

