/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.comm.channels;

import edu.uci.ics.hyracks.api.channels.IInputChannel;
import edu.uci.ics.hyracks.api.channels.IInputChannelMonitor;
import edu.uci.ics.hyracks.api.context.IHyracksCommonContext;
import edu.uci.ics.hyracks.api.dataset.ResultSetId;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.comm.channels.IChannelConnectionFactory;
import edu.uci.ics.hyracks.net.buffers.IBufferAcceptor;
import edu.uci.ics.hyracks.net.buffers.ICloseableBufferAcceptor;
import edu.uci.ics.hyracks.net.protocols.muxdemux.ChannelControlBlock;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DatasetNetworkInputChannel
implements IInputChannel {
    private static final Logger LOGGER = Logger.getLogger(DatasetNetworkInputChannel.class.getName());
    static final int INITIAL_MESSAGE_SIZE = 20;
    private final IChannelConnectionFactory netManager;
    private final SocketAddress remoteAddress;
    private final JobId jobId;
    private final ResultSetId resultSetId;
    private final int partition;
    private final Queue<ByteBuffer> fullQueue;
    private final int nBuffers;
    private ChannelControlBlock ccb;
    private IInputChannelMonitor monitor;
    private Object attachment;

    public DatasetNetworkInputChannel(IChannelConnectionFactory netManager, SocketAddress remoteAddress, JobId jobId, ResultSetId resultSetId, int partition, int nBuffers) {
        this.netManager = netManager;
        this.remoteAddress = remoteAddress;
        this.jobId = jobId;
        this.resultSetId = resultSetId;
        this.partition = partition;
        this.fullQueue = new ArrayDeque<ByteBuffer>(nBuffers);
        this.nBuffers = nBuffers;
    }

    public void registerMonitor(IInputChannelMonitor monitor) {
        this.monitor = monitor;
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public synchronized ByteBuffer getNextBuffer() {
        return this.fullQueue.poll();
    }

    public void recycleBuffer(ByteBuffer buffer) {
        buffer.clear();
        this.ccb.getReadInterface().getEmptyBufferAcceptor().accept(buffer);
    }

    public void open(IHyracksCommonContext ctx) throws HyracksDataException {
        try {
            this.ccb = this.netManager.connect(this.remoteAddress);
        }
        catch (Exception e) {
            throw new HyracksDataException((Throwable)e);
        }
        this.ccb.getReadInterface().setFullBufferAcceptor((ICloseableBufferAcceptor)new ReadFullBufferAcceptor());
        this.ccb.getWriteInterface().setEmptyBufferAcceptor((IBufferAcceptor)new WriteEmptyBufferAcceptor());
        for (int i = 0; i < this.nBuffers; ++i) {
            this.ccb.getReadInterface().getEmptyBufferAcceptor().accept(ctx.allocateFrame());
        }
        ByteBuffer writeBuffer = ByteBuffer.allocate(20);
        writeBuffer.putLong(this.jobId.getId());
        writeBuffer.putLong(this.resultSetId.getId());
        writeBuffer.putInt(this.partition);
        writeBuffer.flip();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Sending partition request for JobId: " + this.jobId + " partition: " + this.partition + " on channel: " + this.ccb);
        }
        this.ccb.getWriteInterface().getFullBufferAcceptor().accept(writeBuffer);
        this.ccb.getWriteInterface().getFullBufferAcceptor().close();
    }

    public void close() throws HyracksDataException {
    }

    private class WriteEmptyBufferAcceptor
    implements IBufferAcceptor {
        private WriteEmptyBufferAcceptor() {
        }

        public void accept(ByteBuffer buffer) {
        }
    }

    private class ReadFullBufferAcceptor
    implements ICloseableBufferAcceptor {
        private ReadFullBufferAcceptor() {
        }

        public void accept(ByteBuffer buffer) {
            DatasetNetworkInputChannel.this.fullQueue.add(buffer);
            DatasetNetworkInputChannel.this.monitor.notifyDataAvailability((IInputChannel)DatasetNetworkInputChannel.this, 1);
        }

        public void close() {
            DatasetNetworkInputChannel.this.monitor.notifyEndOfStream((IInputChannel)DatasetNetworkInputChannel.this);
        }

        public void error(int ecode) {
            DatasetNetworkInputChannel.this.monitor.notifyFailure((IInputChannel)DatasetNetworkInputChannel.this);
        }
    }
}

