/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.net.protocols.tcp;

import edu.uci.ics.hyracks.net.protocols.tcp.ITCPConnectionListener;
import edu.uci.ics.hyracks.net.protocols.tcp.TCPConnection;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;

public class TCPEndpoint {
    private final ITCPConnectionListener connectionListener;
    private final int nThreads;
    private ServerSocketChannel serverSocketChannel;
    private InetSocketAddress localAddress;
    private IOThread[] ioThreads;
    private int nextThread;

    public TCPEndpoint(ITCPConnectionListener connectionListener, int nThreads) {
        this.connectionListener = connectionListener;
        this.nThreads = nThreads;
    }

    public void start(InetSocketAddress localAddress) throws IOException {
        int i;
        if (localAddress != null) {
            this.serverSocketChannel = ServerSocketChannel.open();
            ServerSocket serverSocket = this.serverSocketChannel.socket();
            serverSocket.bind(localAddress);
            this.localAddress = (InetSocketAddress)serverSocket.getLocalSocketAddress();
        }
        this.ioThreads = new IOThread[this.nThreads];
        for (i = 0; i < this.ioThreads.length; ++i) {
            this.ioThreads[i] = new IOThread();
        }
        if (localAddress != null) {
            this.ioThreads[0].registerServerSocket(this.serverSocketChannel);
        }
        for (i = 0; i < this.ioThreads.length; ++i) {
            this.ioThreads[i].start();
        }
    }

    private synchronized int getNextThread() {
        int result = this.nextThread;
        this.nextThread = (this.nextThread + 1) % this.nThreads;
        return result;
    }

    public void initiateConnection(InetSocketAddress remoteAddress) {
        int targetThread = this.getNextThread();
        this.ioThreads[targetThread].initiateConnection(remoteAddress);
    }

    private void distributeIncomingConnection(SocketChannel channel) {
        int targetThread = this.getNextThread();
        this.ioThreads[targetThread].addIncomingConnection(channel);
    }

    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    static /* synthetic */ ServerSocketChannel access$100(TCPEndpoint x0) {
        return x0.serverSocketChannel;
    }

    static /* synthetic */ void access$200(TCPEndpoint x0, SocketChannel x1) {
        x0.distributeIncomingConnection(x1);
    }

    private class IOThread
    extends Thread {
        private final List<InetSocketAddress> pendingConnections;
        private final List<InetSocketAddress> workingPendingConnections;
        private final List<SocketChannel> incomingConnections;
        private final List<SocketChannel> workingIncomingConnections;
        private final Selector selector;

        public IOThread() throws IOException {
            super("TCPEndpoint IO Thread");
            this.setDaemon(true);
            this.setPriority(10);
            this.pendingConnections = new ArrayList<InetSocketAddress>();
            this.workingPendingConnections = new ArrayList<InetSocketAddress>();
            this.incomingConnections = new ArrayList<SocketChannel>();
            this.workingIncomingConnections = new ArrayList<SocketChannel>();
            this.selector = Selector.open();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            while (true) {
                try {
                    block18: while (true) {
                        n = this.selector.select();
                        this.collectOutstandingWork();
                        if (!this.workingPendingConnections.isEmpty()) {
                            for (InetSocketAddress address : this.workingPendingConnections) {
                                channel = SocketChannel.open();
                                channel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
                                channel.configureBlocking(false);
                                connect = false;
                                failure = false;
                                try {
                                    connect = channel.connect(address);
                                }
                                catch (IOException e) {
                                    failure = true;
                                    var8_14 = TCPEndpoint.access$000(TCPEndpoint.this);
                                    synchronized (var8_14) {
                                        TCPEndpoint.access$000(TCPEndpoint.this).connectionFailure(address);
                                    }
                                }
                                if (failure) continue;
                                if (!connect) {
                                    key = channel.register(this.selector, 8);
                                    key.attach(address);
                                    continue;
                                }
                                key = channel.register(this.selector, 0);
                                this.createConnection(key, channel);
                            }
                            this.workingPendingConnections.clear();
                        }
                        if (!this.workingIncomingConnections.isEmpty()) {
                            for (SocketChannel channel : this.workingIncomingConnections) {
                                channel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
                                channel.configureBlocking(false);
                                sKey = channel.register(this.selector, 0);
                                connection = new TCPConnection(TCPEndpoint.this, channel, sKey, this.selector);
                                sKey.attach(connection);
                                failure = TCPEndpoint.access$000(TCPEndpoint.this);
                                synchronized (failure) {
                                    TCPEndpoint.access$000(TCPEndpoint.this).acceptedConnection(connection);
                                }
                            }
                            this.workingIncomingConnections.clear();
                        }
                        if (n <= 0) continue;
                        i = this.selector.selectedKeys().iterator();
                        while (true) {
                            if (i.hasNext()) ** break;
                            continue block18;
                            key = i.next();
                            i.remove();
                            sc = key.channel();
                            readable = key.isReadable();
                            writable = key.isWritable();
                            if (readable || writable) {
                                connection = (TCPConnection)key.attachment();
                                try {
                                    connection.getEventListener().notifyIOReady(connection, readable, writable);
                                }
                                catch (Exception e) {
                                    connection.getEventListener().notifyIOError(e);
                                    connection.close();
                                    continue;
                                }
                            }
                            if (key.isAcceptable()) {
                                if (!IOThread.$assertionsDisabled && sc != TCPEndpoint.access$100(TCPEndpoint.this)) {
                                    throw new AssertionError();
                                }
                                channel = TCPEndpoint.access$100(TCPEndpoint.this).accept();
                                TCPEndpoint.access$200(TCPEndpoint.this, channel);
                                continue;
                            }
                            if (!key.isConnectable()) continue;
                            channel = (SocketChannel)sc;
                            finishConnect = false;
                            try {
                                finishConnect = channel.finishConnect();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                key.cancel();
                                var10_19 = TCPEndpoint.access$000(TCPEndpoint.this);
                                synchronized (var10_19) {
                                    TCPEndpoint.access$000(TCPEndpoint.this).connectionFailure((InetSocketAddress)key.attachment());
                                }
                            }
                            if (!finishConnect) continue;
                            this.createConnection(key, channel);
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createConnection(SelectionKey key, SocketChannel channel) {
            TCPConnection connection = new TCPConnection(TCPEndpoint.this, channel, key, this.selector);
            key.attach(connection);
            key.interestOps(0);
            ITCPConnectionListener iTCPConnectionListener = TCPEndpoint.this.connectionListener;
            synchronized (iTCPConnectionListener) {
                TCPEndpoint.this.connectionListener.connectionEstablished(connection);
            }
        }

        synchronized void initiateConnection(InetSocketAddress remoteAddress) {
            this.pendingConnections.add(remoteAddress);
            this.selector.wakeup();
        }

        synchronized void addIncomingConnection(SocketChannel channel) {
            this.incomingConnections.add(channel);
            this.selector.wakeup();
        }

        void registerServerSocket(ServerSocketChannel serverSocketChannel) throws IOException {
            serverSocketChannel.configureBlocking(false);
            serverSocketChannel.register(this.selector, 16);
        }

        private synchronized void collectOutstandingWork() {
            if (!this.pendingConnections.isEmpty()) {
                this.workingPendingConnections.addAll(this.pendingConnections);
                this.pendingConnections.clear();
            }
            if (!this.incomingConnections.isEmpty()) {
                this.workingIncomingConnections.addAll(this.incomingConnections);
                this.incomingConnections.clear();
            }
        }
    }
}

