/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.net.protocols.tcp;

import edu.uci.ics.hyracks.net.protocols.tcp.ITCPConnectionEventListener;
import edu.uci.ics.hyracks.net.protocols.tcp.TCPEndpoint;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

public class TCPConnection {
    private final TCPEndpoint endpoint;
    private final SocketChannel channel;
    private final SelectionKey key;
    private final Selector selector;
    private ITCPConnectionEventListener eventListener;
    private Object attachment;

    public TCPConnection(TCPEndpoint endpoint, SocketChannel channel, SelectionKey key, Selector selector) {
        this.endpoint = endpoint;
        this.channel = channel;
        this.key = key;
        this.selector = selector;
    }

    public TCPEndpoint getEndpoint() {
        return this.endpoint;
    }

    public SocketChannel getSocketChannel() {
        return this.channel;
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.socket().getLocalSocketAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.channel.socket().getRemoteSocketAddress();
    }

    public void enable(int ops) {
        this.key.interestOps(this.key.interestOps() | ops);
        this.selector.wakeup();
    }

    public void disable(int ops) {
        this.key.interestOps(this.key.interestOps() & ~ops);
        this.selector.wakeup();
    }

    public ITCPConnectionEventListener getEventListener() {
        return this.eventListener;
    }

    public void setEventListener(ITCPConnectionEventListener eventListener) {
        this.eventListener = eventListener;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    public void close() {
        this.key.cancel();
        try {
            this.channel.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

