/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.net.protocols.muxdemux;

import edu.uci.ics.hyracks.net.exceptions.NetException;
import java.nio.ByteBuffer;

class MuxDemuxCommand {
    static final int MAX_CHANNEL_ID = 0x7FFFFFFE;
    static final int COMMAND_SIZE = 8;
    static final int MAX_DATA_VALUE = 0x1FFFFFFF;
    private int channelId;
    private CommandType type;
    private int data;

    MuxDemuxCommand() {
    }

    public int getChannelId() {
        return this.channelId;
    }

    public void setChannelId(int channelId) throws NetException {
        if (channelId > 0x7FFFFFFE) {
            throw new NetException("channelId " + channelId + " exceeds " + 0x7FFFFFFE);
        }
        this.channelId = channelId;
    }

    public CommandType getCommandType() {
        return this.type;
    }

    public void setCommandType(CommandType type) {
        this.type = type;
    }

    public int getData() {
        return this.data;
    }

    public void setData(int data) throws NetException {
        if (data > 0x1FFFFFFF) {
            throw new NetException("data " + data + " exceeds " + 0x1FFFFFFF);
        }
        this.data = data;
    }

    public void write(ByteBuffer buffer) {
        long cmd = (long)this.channelId << 32 | (long)this.type.ordinal() << 29 | (long)(this.data & 0x1FFFFFFF);
        buffer.putLong(cmd);
    }

    public void read(ByteBuffer buffer) {
        long cmd = buffer.getLong();
        this.channelId = (int)(cmd >> 32 & Integer.MAX_VALUE);
        this.type = CommandType.values()[(int)(cmd >> 29 & 7L)];
        this.data = (int)(cmd & 0x1FFFFFFFL);
    }

    public String toString() {
        return this.channelId + ":" + (Object)((Object)this.type) + ":" + this.data;
    }

    static enum CommandType {
        OPEN_CHANNEL,
        CLOSE_CHANNEL,
        CLOSE_CHANNEL_ACK,
        ERROR,
        ADD_CREDITS,
        DATA;

    }
}

