/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.net.protocols.muxdemux;

import edu.uci.ics.hyracks.net.exceptions.NetException;
import edu.uci.ics.hyracks.net.protocols.muxdemux.IChannelOpenListener;
import edu.uci.ics.hyracks.net.protocols.muxdemux.MultiplexedConnection;
import edu.uci.ics.hyracks.net.protocols.muxdemux.MuxDemuxPerformanceCounters;
import edu.uci.ics.hyracks.net.protocols.tcp.ITCPConnectionListener;
import edu.uci.ics.hyracks.net.protocols.tcp.TCPConnection;
import edu.uci.ics.hyracks.net.protocols.tcp.TCPEndpoint;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;

public class MuxDemux {
    private final InetSocketAddress localAddress;
    private final IChannelOpenListener channelOpenListener;
    private final int maxConnectionAttempts;
    private final Map<InetSocketAddress, MultiplexedConnection> connectionMap;
    private final TCPEndpoint tcpEndpoint;
    private final MuxDemuxPerformanceCounters perfCounters;

    public MuxDemux(InetSocketAddress localAddress, IChannelOpenListener listener, int nThreads, int maxConnectionAttempts) {
        this.localAddress = localAddress;
        this.channelOpenListener = listener;
        this.maxConnectionAttempts = maxConnectionAttempts;
        this.connectionMap = new HashMap<InetSocketAddress, MultiplexedConnection>();
        this.tcpEndpoint = new TCPEndpoint(new ITCPConnectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connectionEstablished(TCPConnection connection) {
                MultiplexedConnection mConn;
                MuxDemux muxDemux = MuxDemux.this;
                synchronized (muxDemux) {
                    mConn = (MultiplexedConnection)MuxDemux.this.connectionMap.get(connection.getRemoteAddress());
                }
                assert (mConn != null);
                mConn.setTCPConnection(connection);
                connection.setEventListener(mConn);
                connection.setAttachment(mConn);
            }

            @Override
            public void acceptedConnection(TCPConnection connection) {
                MultiplexedConnection mConn = new MultiplexedConnection(MuxDemux.this);
                mConn.setTCPConnection(connection);
                connection.setEventListener(mConn);
                connection.setAttachment(mConn);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connectionFailure(InetSocketAddress remoteAddress) {
                MuxDemux muxDemux = MuxDemux.this;
                synchronized (muxDemux) {
                    MultiplexedConnection mConn = (MultiplexedConnection)MuxDemux.this.connectionMap.get(remoteAddress);
                    assert (mConn != null);
                    int nConnectionAttempts = mConn.getConnectionAttempts();
                    if (nConnectionAttempts > MuxDemux.this.maxConnectionAttempts) {
                        MuxDemux.this.connectionMap.remove(remoteAddress);
                        mConn.setConnectionFailure();
                    } else {
                        mConn.setConnectionAttempts(nConnectionAttempts + 1);
                        MuxDemux.this.tcpEndpoint.initiateConnection(remoteAddress);
                    }
                }
            }
        }, nThreads);
        this.perfCounters = new MuxDemuxPerformanceCounters();
    }

    public void start() throws IOException {
        this.tcpEndpoint.start(this.localAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiplexedConnection connect(InetSocketAddress remoteAddress) throws InterruptedException, NetException {
        MultiplexedConnection mConn = null;
        MuxDemux muxDemux = this;
        synchronized (muxDemux) {
            mConn = this.connectionMap.get(remoteAddress);
            if (mConn == null) {
                mConn = new MultiplexedConnection(this);
                this.connectionMap.put(remoteAddress, mConn);
                this.tcpEndpoint.initiateConnection(remoteAddress);
            }
        }
        mConn.waitUntilConnected();
        return mConn;
    }

    IChannelOpenListener getChannelOpenListener() {
        return this.channelOpenListener;
    }

    public InetSocketAddress getLocalAddress() {
        return this.tcpEndpoint.getLocalAddress();
    }

    public MuxDemuxPerformanceCounters getPerformanceCounters() {
        return this.perfCounters;
    }
}

