/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.net.protocols.muxdemux;

import edu.uci.ics.hyracks.net.buffers.IBufferAcceptor;
import edu.uci.ics.hyracks.net.buffers.ICloseableBufferAcceptor;
import edu.uci.ics.hyracks.net.exceptions.NetException;
import edu.uci.ics.hyracks.net.protocols.muxdemux.ChannelSet;
import edu.uci.ics.hyracks.net.protocols.muxdemux.IChannelReadInterface;
import edu.uci.ics.hyracks.net.protocols.muxdemux.IChannelWriteInterface;
import edu.uci.ics.hyracks.net.protocols.muxdemux.MultiplexedConnection;
import edu.uci.ics.hyracks.net.protocols.muxdemux.MuxDemuxCommand;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChannelControlBlock {
    private static final Logger LOGGER = Logger.getLogger(ChannelControlBlock.class.getName());
    private final ChannelSet cSet;
    private final int channelId;
    private final ReadInterface ri;
    private final WriteInterface wi;
    private final AtomicBoolean localClose;
    private final AtomicBoolean localCloseAck;
    private final AtomicBoolean remoteClose;
    private final AtomicBoolean remoteCloseAck;

    ChannelControlBlock(ChannelSet cSet, int channelId) {
        this.cSet = cSet;
        this.channelId = channelId;
        this.ri = new ReadInterface();
        this.wi = new WriteInterface();
        this.localClose = new AtomicBoolean();
        this.localCloseAck = new AtomicBoolean();
        this.remoteClose = new AtomicBoolean();
        this.remoteCloseAck = new AtomicBoolean();
    }

    int getChannelId() {
        return this.channelId;
    }

    public IChannelReadInterface getReadInterface() {
        return this.ri;
    }

    public IChannelWriteInterface getWriteInterface() {
        return this.wi;
    }

    synchronized void write(MultiplexedConnection.WriterState writerState) throws NetException {
        this.wi.write(writerState);
    }

    synchronized void writeComplete() {
        this.wi.writeComplete();
    }

    synchronized int read(SocketChannel sc, int size) throws IOException, NetException {
        return this.ri.read(sc, size);
    }

    int getReadCredits() {
        return this.ri.credits;
    }

    void setReadCredits(int credits) {
        this.ri.credits = credits;
    }

    synchronized void addWriteCredits(int delta) {
        this.wi.credits += delta;
        this.wi.adjustChannelWritability();
    }

    synchronized void reportRemoteEOS() {
        this.ri.flush();
        this.ri.fba.close();
        this.remoteClose.set(true);
    }

    void reportRemoteEOSAck() {
        this.remoteCloseAck.set(true);
    }

    boolean getRemoteEOS() {
        return this.remoteClose.get();
    }

    void reportLocalEOSAck() {
        this.localCloseAck.set(true);
    }

    synchronized void reportRemoteError(int ecode) {
        this.ri.flush();
        this.ri.fba.error(ecode);
        this.remoteClose.set(true);
    }

    boolean completelyClosed() {
        return this.localCloseAck.get() && this.remoteCloseAck.get();
    }

    public String toString() {
        return "Channel:" + this.channelId + "[localClose: " + this.localClose + " localCloseAck: " + this.localCloseAck + " remoteClose: " + this.remoteClose + " remoteCloseAck:" + this.remoteCloseAck + " readCredits: " + this.ri.credits + " writeCredits: " + this.wi.credits + "]";
    }

    private final class WriteInterface
    implements IChannelWriteInterface {
        private final Queue<ByteBuffer> wiFullQueue;
        private boolean channelWritabilityState;
        private final ICloseableBufferAcceptor fba = new ICloseableBufferAcceptor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(ByteBuffer buffer) {
                ChannelControlBlock channelControlBlock = ChannelControlBlock.this;
                synchronized (channelControlBlock) {
                    WriteInterface.this.wiFullQueue.add(buffer);
                    WriteInterface.this.adjustChannelWritability();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                ChannelControlBlock channelControlBlock = ChannelControlBlock.this;
                synchronized (channelControlBlock) {
                    if (WriteInterface.this.eos) {
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.warning("Received duplicate close() on channel: " + ChannelControlBlock.this.channelId);
                        }
                        return;
                    }
                    WriteInterface.this.eos = true;
                    WriteInterface.this.adjustChannelWritability();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void error(int ecode) {
                ChannelControlBlock channelControlBlock = ChannelControlBlock.this;
                synchronized (channelControlBlock) {
                    WriteInterface.this.ecode = ecode;
                    WriteInterface.this.adjustChannelWritability();
                }
            }
        };
        private IBufferAcceptor eba;
        private int credits = 0;
        private boolean eos = false;
        private boolean eosSent = false;
        private int ecode = -1;
        private boolean ecodeSent = false;
        private ByteBuffer currentWriteBuffer;

        WriteInterface() {
            this.wiFullQueue = new ArrayDeque<ByteBuffer>();
        }

        @Override
        public void setEmptyBufferAcceptor(IBufferAcceptor emptyBufferAcceptor) {
            this.eba = emptyBufferAcceptor;
        }

        @Override
        public ICloseableBufferAcceptor getFullBufferAcceptor() {
            return this.fba;
        }

        void write(MultiplexedConnection.WriterState writerState) throws NetException {
            if (this.currentWriteBuffer == null) {
                this.currentWriteBuffer = this.wiFullQueue.poll();
            }
            if (this.currentWriteBuffer != null) {
                int size = Math.min(this.currentWriteBuffer.remaining(), this.credits);
                if (size > 0) {
                    this.credits -= size;
                    writerState.command.setChannelId(ChannelControlBlock.this.channelId);
                    writerState.command.setCommandType(MuxDemuxCommand.CommandType.DATA);
                    writerState.command.setData(size);
                    writerState.reset(this.currentWriteBuffer, size, ChannelControlBlock.this);
                } else {
                    this.adjustChannelWritability();
                }
            } else if (this.ecode >= 0 && !this.ecodeSent) {
                writerState.command.setChannelId(ChannelControlBlock.this.channelId);
                writerState.command.setCommandType(MuxDemuxCommand.CommandType.ERROR);
                writerState.command.setData(this.ecode);
                writerState.reset(null, 0, null);
                this.ecodeSent = true;
                ChannelControlBlock.this.localClose.set(true);
                this.adjustChannelWritability();
            } else if (this.eos && !this.eosSent) {
                writerState.command.setChannelId(ChannelControlBlock.this.channelId);
                writerState.command.setCommandType(MuxDemuxCommand.CommandType.CLOSE_CHANNEL);
                writerState.command.setData(0);
                writerState.reset(null, 0, null);
                this.eosSent = true;
                ChannelControlBlock.this.localClose.set(true);
                this.adjustChannelWritability();
            }
        }

        void writeComplete() {
            if (this.currentWriteBuffer.remaining() <= 0) {
                this.currentWriteBuffer.clear();
                this.eba.accept(this.currentWriteBuffer);
                this.currentWriteBuffer = null;
                this.adjustChannelWritability();
            }
        }

        private boolean computeWritability() {
            boolean writableDataPresent;
            boolean bl = writableDataPresent = this.currentWriteBuffer != null || !this.wiFullQueue.isEmpty();
            if (writableDataPresent) {
                return this.credits > 0;
            }
            if (this.eos && !this.eosSent) {
                return true;
            }
            return this.ecode >= 0 && !this.ecodeSent;
        }

        void adjustChannelWritability() {
            boolean writable = this.computeWritability();
            if (writable) {
                if (!this.channelWritabilityState) {
                    ChannelControlBlock.this.cSet.markPendingWrite(ChannelControlBlock.this.channelId);
                }
            } else if (this.channelWritabilityState) {
                ChannelControlBlock.this.cSet.unmarkPendingWrite(ChannelControlBlock.this.channelId);
            }
            this.channelWritabilityState = writable;
        }
    }

    private final class ReadInterface
    implements IChannelReadInterface {
        private final Deque<ByteBuffer> riEmptyStack;
        private final IBufferAcceptor eba = new IBufferAcceptor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(ByteBuffer buffer) {
                int delta = buffer.remaining();
                ChannelControlBlock channelControlBlock = ChannelControlBlock.this;
                synchronized (channelControlBlock) {
                    if (ChannelControlBlock.this.remoteClose.get()) {
                        return;
                    }
                    ReadInterface.this.riEmptyStack.push(buffer);
                }
                ChannelControlBlock.this.cSet.addPendingCredits(ChannelControlBlock.this.channelId, delta);
            }
        };
        private ICloseableBufferAcceptor fba;
        private volatile int credits = 0;
        private ByteBuffer currentReadBuffer;

        ReadInterface() {
            this.riEmptyStack = new ArrayDeque<ByteBuffer>();
        }

        @Override
        public void setFullBufferAcceptor(ICloseableBufferAcceptor fullBufferAcceptor) {
            this.fba = fullBufferAcceptor;
        }

        @Override
        public IBufferAcceptor getEmptyBufferAcceptor() {
            return this.eba;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int read(SocketChannel sc, int size) throws IOException, NetException {
            while (size > 0) {
                int rSize;
                if (this.currentReadBuffer == null) {
                    this.currentReadBuffer = this.riEmptyStack.poll();
                    assert (this.currentReadBuffer != null);
                }
                if ((rSize = Math.min(size, this.currentReadBuffer.remaining())) > 0) {
                    int len;
                    this.currentReadBuffer.limit(this.currentReadBuffer.position() + rSize);
                    try {
                        len = sc.read(this.currentReadBuffer);
                        if (len < 0) {
                            throw new NetException("Socket Closed");
                        }
                    }
                    finally {
                        this.currentReadBuffer.limit(this.currentReadBuffer.capacity());
                    }
                    size -= len;
                    if (len < rSize) {
                        return size;
                    }
                } else {
                    return size;
                }
                if (this.currentReadBuffer.remaining() > 0) continue;
                this.flush();
            }
            return size;
        }

        void flush() {
            if (this.currentReadBuffer != null) {
                this.currentReadBuffer.flip();
                this.fba.accept(this.currentReadBuffer);
                this.currentReadBuffer = null;
            }
        }
    }
}

