/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.compiler.api;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.compiler.api.AbstractCompilerFactoryBuilder;
import edu.uci.ics.hyracks.algebricks.compiler.api.ICompiler;
import edu.uci.ics.hyracks.algebricks.compiler.api.ICompilerFactory;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.IExpressionEvalSizeComputer;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.IExpressionTypeComputer;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.IMergeAggregationExpressionFactory;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.INullableTypeComputer;
import edu.uci.ics.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import edu.uci.ics.hyracks.algebricks.core.algebra.prettyprint.LogicalOperatorPrettyPrintVisitor;
import edu.uci.ics.hyracks.algebricks.core.algebra.typing.ITypingContext;
import edu.uci.ics.hyracks.algebricks.core.config.AlgebricksConfig;
import edu.uci.ics.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import edu.uci.ics.hyracks.algebricks.core.jobgen.impl.PlanCompiler;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.AlgebricksOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.HeuristicOptimizer;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IOptimizationContextFactory;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;
import edu.uci.ics.hyracks.api.job.IJobletEventListenerFactory;
import edu.uci.ics.hyracks.api.job.JobSpecification;

public class HeuristicCompilerFactoryBuilder
extends AbstractCompilerFactoryBuilder {
    private IOptimizationContextFactory optCtxFactory;

    public HeuristicCompilerFactoryBuilder() {
        this.optCtxFactory = DefaultOptimizationContextFactory.INSTANCE;
    }

    public HeuristicCompilerFactoryBuilder(IOptimizationContextFactory optCtxFactory) {
        this.optCtxFactory = optCtxFactory;
    }

    @Override
    public ICompilerFactory create() {
        return new ICompilerFactory(){

            @Override
            public ICompiler createCompiler(final ILogicalPlan plan, final IMetadataProvider<?, ?> metadata, int varCounter) {
                final IOptimizationContext oc = HeuristicCompilerFactoryBuilder.this.optCtxFactory.createOptimizationContext(varCounter, HeuristicCompilerFactoryBuilder.this.expressionEvalSizeComputer, HeuristicCompilerFactoryBuilder.this.mergeAggregationExpressionFactory, HeuristicCompilerFactoryBuilder.this.expressionTypeComputer, HeuristicCompilerFactoryBuilder.this.nullableTypeComputer, HeuristicCompilerFactoryBuilder.this.physicalOptimizationConfig);
                oc.setMetadataDeclarations(metadata);
                final HeuristicOptimizer opt = new HeuristicOptimizer(plan, HeuristicCompilerFactoryBuilder.this.logicalRewrites, HeuristicCompilerFactoryBuilder.this.physicalRewrites, oc);
                return new ICompiler(){

                    @Override
                    public void optimize() throws AlgebricksException {
                        opt.optimize();
                    }

                    @Override
                    public JobSpecification createJob(Object appContext, IJobletEventListenerFactory jobEventListenerFactory) throws AlgebricksException {
                        AlgebricksConfig.ALGEBRICKS_LOGGER.fine("Starting Job Generation.\n");
                        JobGenContext context = new JobGenContext(null, metadata, appContext, HeuristicCompilerFactoryBuilder.this.serializerDeserializerProvider, HeuristicCompilerFactoryBuilder.this.hashFunctionFactoryProvider, HeuristicCompilerFactoryBuilder.this.hashFunctionFamilyProvider, HeuristicCompilerFactoryBuilder.this.comparatorFactoryProvider, HeuristicCompilerFactoryBuilder.this.typeTraitProvider, HeuristicCompilerFactoryBuilder.this.binaryBooleanInspectorFactory, HeuristicCompilerFactoryBuilder.this.binaryIntegerInspectorFactory, HeuristicCompilerFactoryBuilder.this.printerProvider, HeuristicCompilerFactoryBuilder.this.nullWriterFactory, HeuristicCompilerFactoryBuilder.this.normalizedKeyComputerFactoryProvider, HeuristicCompilerFactoryBuilder.this.expressionRuntimeProvider, HeuristicCompilerFactoryBuilder.this.expressionTypeComputer, HeuristicCompilerFactoryBuilder.this.nullableTypeComputer, (ITypingContext)oc, HeuristicCompilerFactoryBuilder.this.expressionEvalSizeComputer, HeuristicCompilerFactoryBuilder.this.partialAggregationTypeComputer, HeuristicCompilerFactoryBuilder.this.predEvaluatorFactoryProvider, HeuristicCompilerFactoryBuilder.this.physicalOptimizationConfig.getFrameSize(), HeuristicCompilerFactoryBuilder.this.clusterLocations);
                        PlanCompiler pc = new PlanCompiler(context);
                        return pc.compilePlan(plan, null, jobEventListenerFactory);
                    }
                };
            }
        };
    }

    public static class DefaultOptimizationContextFactory
    implements IOptimizationContextFactory {
        public static final DefaultOptimizationContextFactory INSTANCE = new DefaultOptimizationContextFactory();

        private DefaultOptimizationContextFactory() {
        }

        public IOptimizationContext createOptimizationContext(int varCounter, IExpressionEvalSizeComputer expressionEvalSizeComputer, IMergeAggregationExpressionFactory mergeAggregationExpressionFactory, IExpressionTypeComputer expressionTypeComputer, INullableTypeComputer nullableTypeComputer, PhysicalOptimizationConfig physicalOptimizationConfig) {
            LogicalOperatorPrettyPrintVisitor prettyPrintVisitor = new LogicalOperatorPrettyPrintVisitor();
            return new AlgebricksOptimizationContext(varCounter, expressionEvalSizeComputer, mergeAggregationExpressionFactory, expressionTypeComputer, nullableTypeComputer, physicalOptimizationConfig, prettyPrintVisitor);
        }
    }
}

