/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.core.rewriter.base;

import java.util.Properties;

public class PhysicalOptimizationConfig {
    private static final int MB = 0x100000;
    private static final String FRAMESIZE = "FRAMESIZE";
    private static final String MAX_FRAMES_EXTERNAL_SORT = "MAX_FRAMES_EXTERNAL_SORT";
    private static final String MAX_FRAMES_EXTERNAL_GROUP_BY = "MAX_FRAMES_EXTERNAL_GROUP_BY";
    private static final String MAX_FRAMES_LEFT_INPUT_HYBRID_HASH = "MAX_FRAMES_LEFT_INPUT_HYBRID_HASH";
    private static final String MAX_FRAMES_HYBRID_HASH = "MAX_FRAMES_HYBRID_HASH";
    private static final String FUDGE_FACTOR = "FUDGE_FACTOR";
    private static final String MAX_RECORDS_PER_FRAME = "MAX_RECORDS_PER_FRAME";
    private static final String DEFAULT_HASH_GROUP_TABLE_SIZE = "DEFAULT_HASH_GROUP_TABLE_SIZE";
    private static final String DEFAULT_EXTERNAL_GROUP_TABLE_SIZE = "DEFAULT_EXTERNAL_GROUP_TABLE_SIZE";
    private static final String DEFAULT_IN_MEM_HASH_JOIN_TABLE_SIZE = "DEFAULT_IN_MEM_HASH_JOIN_TABLE_SIZE";
    private Properties properties = new Properties();

    public PhysicalOptimizationConfig() {
        int frameSize = 32768;
        this.setInt(FRAMESIZE, frameSize);
        this.setInt(MAX_FRAMES_EXTERNAL_SORT, (int)(0x2000000L / (long)frameSize));
        this.setInt(MAX_FRAMES_EXTERNAL_GROUP_BY, (int)(0x2000000L / (long)frameSize));
        this.setInt(DEFAULT_HASH_GROUP_TABLE_SIZE, 0xA00007);
        this.setInt(DEFAULT_EXTERNAL_GROUP_TABLE_SIZE, 0xA00007);
        this.setInt(DEFAULT_IN_MEM_HASH_JOIN_TABLE_SIZE, 0xA00007);
    }

    public int getFrameSize() {
        return this.getInt(FRAMESIZE, 32768);
    }

    public void setFrameSize(int frameSize) {
        this.setInt(FRAMESIZE, frameSize);
    }

    public double getFudgeFactor() {
        return this.getDouble(FUDGE_FACTOR, 1.3);
    }

    public void setFudgeFactor(double fudgeFactor) {
        this.setDouble(FUDGE_FACTOR, fudgeFactor);
    }

    public int getMaxRecordsPerFrame() {
        return this.getInt(MAX_RECORDS_PER_FRAME, 512);
    }

    public void setMaxRecordsPerFrame(int maxRecords) {
        this.setInt(MAX_RECORDS_PER_FRAME, maxRecords);
    }

    public int getMaxFramesLeftInputHybridHash() {
        int frameSize = this.getFrameSize();
        return this.getInt(MAX_FRAMES_LEFT_INPUT_HYBRID_HASH, (int)(0x2300000000L / (long)frameSize));
    }

    public void setMaxFramesLeftInputHybridHash(int frameLimit) {
        this.setInt(MAX_FRAMES_LEFT_INPUT_HYBRID_HASH, frameLimit);
    }

    public int getMaxFramesHybridHash() {
        int frameSize = this.getFrameSize();
        return this.getInt(MAX_FRAMES_HYBRID_HASH, (int)(0x4000000L / (long)frameSize));
    }

    public void setMaxFramesHybridHash(int frameLimit) {
        this.setInt(MAX_FRAMES_HYBRID_HASH, frameLimit);
    }

    public int getMaxFramesExternalGroupBy() {
        int frameSize = this.getFrameSize();
        return this.getInt(MAX_FRAMES_EXTERNAL_GROUP_BY, (int)(0x10000000L / (long)frameSize));
    }

    public void setMaxFramesExternalGroupBy(int frameLimit) {
        this.setInt(MAX_FRAMES_EXTERNAL_GROUP_BY, frameLimit);
    }

    public int getMaxFramesExternalSort() {
        int frameSize = this.getFrameSize();
        return this.getInt(MAX_FRAMES_EXTERNAL_SORT, (int)(0x2000000L / (long)frameSize));
    }

    public void setMaxFramesExternalSort(int frameLimit) {
        this.setInt(MAX_FRAMES_EXTERNAL_SORT, frameLimit);
    }

    public int getHashGroupByTableSize() {
        return this.getInt(DEFAULT_HASH_GROUP_TABLE_SIZE, 0xA00007);
    }

    public void setHashGroupByTableSize(int tableSize) {
        this.setInt(DEFAULT_HASH_GROUP_TABLE_SIZE, tableSize);
    }

    public int getExternalGroupByTableSize() {
        return this.getInt(DEFAULT_EXTERNAL_GROUP_TABLE_SIZE, 0xA00007);
    }

    public void setExternalGroupByTableSize(int tableSize) {
        this.setInt(DEFAULT_EXTERNAL_GROUP_TABLE_SIZE, tableSize);
    }

    public int getInMemHashJoinTableSize() {
        return this.getInt(DEFAULT_IN_MEM_HASH_JOIN_TABLE_SIZE, 0xA00007);
    }

    public void setInMemHashJoinTableSize(int tableSize) {
        this.setInt(DEFAULT_IN_MEM_HASH_JOIN_TABLE_SIZE, tableSize);
    }

    private void setInt(String property, int value) {
        this.properties.setProperty(property, Integer.toString(value));
    }

    private int getInt(String property, int defaultValue) {
        String value = this.properties.getProperty(property);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    private void setDouble(String property, double value) {
        this.properties.setProperty(property, Double.toString(value));
    }

    private double getDouble(String property, double defaultValue) {
        String value = this.properties.getProperty(property);
        if (value == null) {
            return defaultValue;
        }
        return Double.parseDouble(value);
    }
}

