/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.core.rewriter.base;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.common.utils.Pair;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import edu.uci.ics.hyracks.algebricks.core.algebra.prettyprint.PlanPrettyPrinter;
import edu.uci.ics.hyracks.algebricks.core.config.AlgebricksConfig;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.AbstractRuleController;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;

public class HeuristicOptimizer {
    public static PhysicalOperatorTag[] hyraxOperators = new PhysicalOperatorTag[]{PhysicalOperatorTag.DATASOURCE_SCAN, PhysicalOperatorTag.BTREE_SEARCH, PhysicalOperatorTag.EXTERNAL_GROUP_BY, PhysicalOperatorTag.HASH_GROUP_BY, PhysicalOperatorTag.HDFS_READER, PhysicalOperatorTag.HYBRID_HASH_JOIN, PhysicalOperatorTag.IN_MEMORY_HASH_JOIN, PhysicalOperatorTag.NESTED_LOOP, PhysicalOperatorTag.PRE_SORTED_DISTINCT_BY, PhysicalOperatorTag.PRE_CLUSTERED_GROUP_BY, PhysicalOperatorTag.SPLIT, PhysicalOperatorTag.STABLE_SORT, PhysicalOperatorTag.UNION_ALL};
    public static PhysicalOperatorTag[] hyraxOperatorsBelowWhichJobGenIsDisabled = new PhysicalOperatorTag[0];
    private IOptimizationContext context;
    private List<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> logicalRewrites;
    private List<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> physicalRewrites;
    private ILogicalPlan plan;

    public static boolean isHyraxOp(PhysicalOperatorTag opTag) {
        for (PhysicalOperatorTag t : hyraxOperators) {
            if (t != opTag) continue;
            return true;
        }
        return false;
    }

    public HeuristicOptimizer(ILogicalPlan plan, List<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> logicalRewrites, List<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> physicalRewrites, IOptimizationContext context) {
        this.plan = plan;
        this.context = context;
        this.logicalRewrites = logicalRewrites;
        this.physicalRewrites = physicalRewrites;
    }

    public void optimize() throws AlgebricksException {
        if (this.plan == null) {
            return;
        }
        AlgebricksConfig.ALGEBRICKS_LOGGER.fine("Starting logical optimizations.\n");
        StringBuilder sb = new StringBuilder();
        PlanPrettyPrinter.printPlan(this.plan, sb, this.context.getPrettyPrintVisitor(), 0);
        AlgebricksConfig.ALGEBRICKS_LOGGER.fine("Logical Plan:\n" + sb.toString());
        this.runOptimizationSets(this.plan, this.logicalRewrites);
        HeuristicOptimizer.computeSchemaBottomUpForPlan(this.plan);
        this.runPhysicalOptimizations(this.plan, this.physicalRewrites);
        StringBuilder sb2 = new StringBuilder();
        PlanPrettyPrinter.printPlan(this.plan, sb2, this.context.getPrettyPrintVisitor(), 0);
        AlgebricksConfig.ALGEBRICKS_LOGGER.info("Optimized Plan:\n" + sb2.toString());
    }

    private void runOptimizationSets(ILogicalPlan plan, List<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> optimSet) throws AlgebricksException {
        for (Pair<AbstractRuleController, List<IAlgebraicRewriteRule>> ruleList : optimSet) {
            for (Mutable<ILogicalOperator> r : plan.getRoots()) {
                ((AbstractRuleController)ruleList.first).setContext(this.context);
                ((AbstractRuleController)ruleList.first).rewriteWithRuleCollection(r, (Collection)ruleList.second);
            }
        }
    }

    private static void computeSchemaBottomUpForPlan(ILogicalPlan p) throws AlgebricksException {
        for (Mutable<ILogicalOperator> r : p.getRoots()) {
            HeuristicOptimizer.computeSchemaBottomUpForOp((AbstractLogicalOperator)r.getValue());
        }
    }

    private static void computeSchemaBottomUpForOp(AbstractLogicalOperator op) throws AlgebricksException {
        for (Mutable<ILogicalOperator> i : op.getInputs()) {
            HeuristicOptimizer.computeSchemaBottomUpForOp((AbstractLogicalOperator)i.getValue());
        }
        if (op.hasNestedPlans()) {
            AbstractOperatorWithNestedPlans a = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan p : a.getNestedPlans()) {
                HeuristicOptimizer.computeSchemaBottomUpForPlan(p);
            }
        }
        op.recomputeSchema();
    }

    private void runPhysicalOptimizations(ILogicalPlan plan, List<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> physicalRewrites) throws AlgebricksException {
        AlgebricksConfig.ALGEBRICKS_LOGGER.fine("Starting physical optimizations.\n");
        this.runOptimizationSets(plan, physicalRewrites);
    }
}

