/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.core.rewriter.base;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import edu.uci.ics.hyracks.algebricks.core.algebra.prettyprint.LogicalOperatorPrettyPrintVisitor;
import edu.uci.ics.hyracks.algebricks.core.algebra.prettyprint.PlanPrettyPrinter;
import edu.uci.ics.hyracks.algebricks.core.config.AlgebricksConfig;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import java.util.Collection;
import java.util.logging.Level;
import org.apache.commons.lang3.mutable.Mutable;

public abstract class AbstractRuleController {
    protected IOptimizationContext context;

    public void setContext(IOptimizationContext context) {
        this.context = context;
    }

    public abstract boolean rewriteWithRuleCollection(Mutable<ILogicalOperator> var1, Collection<IAlgebraicRewriteRule> var2) throws AlgebricksException;

    protected boolean rewriteOperatorRef(Mutable<ILogicalOperator> opRef, IAlgebraicRewriteRule rule) throws AlgebricksException {
        return this.rewriteOperatorRef(opRef, rule, true, false);
    }

    private String getPlanString(Mutable<ILogicalOperator> opRef) throws AlgebricksException {
        if (AlgebricksConfig.ALGEBRICKS_LOGGER.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            LogicalOperatorPrettyPrintVisitor pvisitor = this.context.getPrettyPrintVisitor();
            PlanPrettyPrinter.printOperator((AbstractLogicalOperator)opRef.getValue(), sb, pvisitor, 0);
            return sb.toString();
        }
        return null;
    }

    private void printRuleApplication(IAlgebraicRewriteRule rule, String beforePlan, String afterPlan) throws AlgebricksException {
        if (AlgebricksConfig.ALGEBRICKS_LOGGER.isLoggable(Level.FINE)) {
            AlgebricksConfig.ALGEBRICKS_LOGGER.fine(">>>> Rule " + rule.getClass() + " fired.\n");
            AlgebricksConfig.ALGEBRICKS_LOGGER.fine(">>>> Before plan\n" + beforePlan + "\n");
            AlgebricksConfig.ALGEBRICKS_LOGGER.fine(">>>> After plan\n" + afterPlan + "\n");
        }
    }

    protected boolean rewriteOperatorRef(Mutable<ILogicalOperator> opRef, IAlgebraicRewriteRule rule, boolean enterNestedPlans, boolean fullDFS) throws AlgebricksException {
        String preBeforePlan = this.getPlanString(opRef);
        if (rule.rewritePre(opRef, this.context)) {
            String preAfterPlan = this.getPlanString(opRef);
            this.printRuleApplication(rule, preBeforePlan, preAfterPlan);
            return true;
        }
        boolean rewritten = false;
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        for (Mutable<ILogicalOperator> inp : op.getInputs()) {
            if (!this.rewriteOperatorRef(inp, rule, enterNestedPlans, fullDFS)) continue;
            rewritten = true;
            if (fullDFS) continue;
            break;
        }
        if (op.hasNestedPlans() && enterNestedPlans) {
            AbstractOperatorWithNestedPlans o2 = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan p : o2.getNestedPlans()) {
                for (Mutable<ILogicalOperator> r : p.getRoots()) {
                    if (!this.rewriteOperatorRef(r, rule, enterNestedPlans, fullDFS)) continue;
                    rewritten = true;
                    if (fullDFS) continue;
                    break;
                }
                if (!rewritten || fullDFS) continue;
                break;
            }
        }
        String postBeforePlan = this.getPlanString(opRef);
        if (rule.rewritePost(opRef, this.context)) {
            String postAfterPlan = this.getPlanString(opRef);
            this.printRuleApplication(rule, postBeforePlan, postAfterPlan);
            return true;
        }
        return rewritten;
    }
}

