/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.core.jobgen.impl;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import edu.uci.ics.hyracks.algebricks.core.jobgen.impl.ConnectorPolicyAssignmentPolicy;
import edu.uci.ics.hyracks.algebricks.core.jobgen.impl.JobBuilder;
import edu.uci.ics.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import edu.uci.ics.hyracks.algebricks.core.jobgen.impl.OperatorSchemaImpl;
import edu.uci.ics.hyracks.api.dataflow.connectors.IConnectorPolicyAssignmentPolicy;
import edu.uci.ics.hyracks.api.job.IJobletEventListenerFactory;
import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import edu.uci.ics.hyracks.api.job.JobSpecification;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.Mutable;

public class PlanCompiler {
    private JobGenContext context;
    private Map<Mutable<ILogicalOperator>, List<Mutable<ILogicalOperator>>> operatorVisitedToParents = new HashMap<Mutable<ILogicalOperator>, List<Mutable<ILogicalOperator>>>();

    public PlanCompiler(JobGenContext context) {
        this.context = context;
    }

    public JobGenContext getContext() {
        return this.context;
    }

    public JobSpecification compilePlan(ILogicalPlan plan, IOperatorSchema outerPlanSchema, IJobletEventListenerFactory jobEventListenerFactory) throws AlgebricksException {
        JobSpecification spec = new JobSpecification(this.context.getFrameSize());
        if (jobEventListenerFactory != null) {
            spec.setJobletEventListenerFactory(jobEventListenerFactory);
        }
        ArrayList<ILogicalOperator> rootOps = new ArrayList<ILogicalOperator>();
        JobBuilder builder = new JobBuilder(spec, this.context.getClusterLocations());
        for (Mutable<ILogicalOperator> opRef : plan.getRoots()) {
            this.compileOpRef(opRef, (IOperatorDescriptorRegistry)spec, builder, outerPlanSchema);
            rootOps.add((ILogicalOperator)opRef.getValue());
        }
        this.reviseEdges(builder);
        this.operatorVisitedToParents.clear();
        builder.buildSpec(rootOps);
        spec.setConnectorPolicyAssignmentPolicy((IConnectorPolicyAssignmentPolicy)new ConnectorPolicyAssignmentPolicy());
        spec.setUseConnectorPolicyForScheduling(false);
        return spec;
    }

    private void compileOpRef(Mutable<ILogicalOperator> opRef, IOperatorDescriptorRegistry spec, IHyracksJobBuilder builder, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        int n = op.getInputs().size();
        IOperatorSchema[] schemas = new IOperatorSchema[n];
        int i = 0;
        for (Mutable<ILogicalOperator> opRef2 : op.getInputs()) {
            List<Mutable<ILogicalOperator>> parents = this.operatorVisitedToParents.get(opRef2);
            if (parents == null) {
                parents = new ArrayList<Mutable<ILogicalOperator>>();
                this.operatorVisitedToParents.put(opRef2, parents);
                parents.add(opRef);
                this.compileOpRef(opRef2, spec, builder, outerPlanSchema);
                schemas[i++] = this.context.getSchema((ILogicalOperator)opRef2.getValue());
                continue;
            }
            if (!parents.contains(opRef)) {
                parents.add(opRef);
            }
            schemas[i++] = this.context.getSchema((ILogicalOperator)opRef2.getValue());
        }
        OperatorSchemaImpl opSchema = new OperatorSchemaImpl();
        this.context.putSchema(op, opSchema);
        op.getVariablePropagationPolicy().propagateVariables(opSchema, schemas);
        op.contributeRuntimeOperator(builder, this.context, opSchema, schemas, outerPlanSchema);
    }

    private void reviseEdges(IHyracksJobBuilder builder) {
        for (Map.Entry<Mutable<ILogicalOperator>, List<Mutable<ILogicalOperator>>> entry : this.operatorVisitedToParents.entrySet()) {
            Mutable<ILogicalOperator> child = entry.getKey();
            List<Mutable<ILogicalOperator>> parents = entry.getValue();
            if (parents.size() <= 1) continue;
            int i = 0;
            for (Mutable<ILogicalOperator> parent : parents) {
                builder.contributeGraphEdge((ILogicalOperator)child.getValue(), i, (ILogicalOperator)parent.getValue(), 0);
                ++i;
            }
        }
    }
}

