/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.core.jobgen.impl;

import edu.uci.ics.hyracks.algebricks.common.constraints.AlgebricksCountPartitionConstraint;
import edu.uci.ics.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import edu.uci.ics.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraintHelper;
import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.common.utils.Pair;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import edu.uci.ics.hyracks.algebricks.runtime.operators.meta.AlgebricksMetaOperatorDescriptor;
import edu.uci.ics.hyracks.api.dataflow.ConnectorDescriptorId;
import edu.uci.ics.hyracks.api.dataflow.IConnectorDescriptor;
import edu.uci.ics.hyracks.api.dataflow.IOperatorDescriptor;
import edu.uci.ics.hyracks.api.dataflow.OperatorDescriptorId;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import edu.uci.ics.hyracks.api.job.JobSpecification;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JobBuilder
implements IHyracksJobBuilder {
    private JobSpecification jobSpec;
    private AlgebricksPartitionConstraint clusterLocations;
    private Map<ILogicalOperator, ArrayList<ILogicalOperator>> outEdges = new HashMap<ILogicalOperator, ArrayList<ILogicalOperator>>();
    private Map<ILogicalOperator, ArrayList<ILogicalOperator>> inEdges = new HashMap<ILogicalOperator, ArrayList<ILogicalOperator>>();
    private Map<ILogicalOperator, Pair<IConnectorDescriptor, IHyracksJobBuilder.TargetConstraint>> connectors = new HashMap<ILogicalOperator, Pair<IConnectorDescriptor, IHyracksJobBuilder.TargetConstraint>>();
    private Map<ILogicalOperator, Pair<IPushRuntimeFactory, RecordDescriptor>> microOps = new HashMap<ILogicalOperator, Pair<IPushRuntimeFactory, RecordDescriptor>>();
    private Map<IPushRuntimeFactory, ILogicalOperator> revMicroOpMap = new HashMap<IPushRuntimeFactory, ILogicalOperator>();
    private Map<ILogicalOperator, IOperatorDescriptor> hyracksOps = new HashMap<ILogicalOperator, IOperatorDescriptor>();
    private Map<ILogicalOperator, AlgebricksPartitionConstraint> pcForMicroOps = new HashMap<ILogicalOperator, AlgebricksPartitionConstraint>();
    private int aodCounter = 0;
    private Map<ILogicalOperator, Integer> algebraicOpBelongingToMetaAsterixOp = new HashMap<ILogicalOperator, Integer>();
    private Map<Integer, List<Pair<IPushRuntimeFactory, RecordDescriptor>>> metaAsterixOpSkeletons = new HashMap<Integer, List<Pair<IPushRuntimeFactory, RecordDescriptor>>>();
    private Map<Integer, AlgebricksMetaOperatorDescriptor> metaAsterixOps = new HashMap<Integer, AlgebricksMetaOperatorDescriptor>();
    private final Map<IOperatorDescriptor, AlgebricksPartitionConstraint> partitionConstraintMap = new HashMap<IOperatorDescriptor, AlgebricksPartitionConstraint>();

    public JobBuilder(JobSpecification jobSpec, AlgebricksPartitionConstraint clusterLocations) {
        this.jobSpec = jobSpec;
        this.clusterLocations = clusterLocations;
    }

    @Override
    public void contributeMicroOperator(ILogicalOperator op, IPushRuntimeFactory runtime, RecordDescriptor recDesc) {
        this.contributeMicroOperator(op, runtime, recDesc, null);
    }

    @Override
    public void contributeMicroOperator(ILogicalOperator op, IPushRuntimeFactory runtime, RecordDescriptor recDesc, AlgebricksPartitionConstraint pc) {
        AbstractLogicalOperator logicalOp;
        this.microOps.put(op, (Pair<IPushRuntimeFactory, RecordDescriptor>)new Pair((Object)runtime, (Object)recDesc));
        this.revMicroOpMap.put(runtime, op);
        if (pc != null) {
            this.pcForMicroOps.put(op, pc);
        }
        if ((logicalOp = (AbstractLogicalOperator)op).getExecutionMode() == AbstractLogicalOperator.ExecutionMode.UNPARTITIONED && pc == null) {
            AlgebricksCountPartitionConstraint apc = new AlgebricksCountPartitionConstraint(1);
            this.pcForMicroOps.put(logicalOp, (AlgebricksPartitionConstraint)apc);
        }
    }

    @Override
    public void contributeConnector(ILogicalOperator exchgOp, IConnectorDescriptor conn) {
        this.connectors.put(exchgOp, (Pair<IConnectorDescriptor, IHyracksJobBuilder.TargetConstraint>)new Pair((Object)conn, null));
    }

    @Override
    public void contributeConnectorWithTargetConstraint(ILogicalOperator exchgOp, IConnectorDescriptor conn, IHyracksJobBuilder.TargetConstraint numberOfTargetPartitions) {
        this.connectors.put(exchgOp, (Pair<IConnectorDescriptor, IHyracksJobBuilder.TargetConstraint>)new Pair((Object)conn, (Object)numberOfTargetPartitions));
    }

    @Override
    public void contributeGraphEdge(ILogicalOperator src, int srcOutputIndex, ILogicalOperator dest, int destInputIndex) {
        ArrayList<ILogicalOperator> outputs = this.outEdges.get(src);
        if (outputs == null) {
            outputs = new ArrayList();
            this.outEdges.put(src, outputs);
        }
        this.addAtPos(outputs, dest, srcOutputIndex);
        ArrayList<ILogicalOperator> inp = this.inEdges.get(dest);
        if (inp == null) {
            inp = new ArrayList();
            this.inEdges.put(dest, inp);
        }
        this.addAtPos(inp, src, destInputIndex);
    }

    @Override
    public void contributeHyracksOperator(ILogicalOperator op, IOperatorDescriptor opDesc) {
        this.hyracksOps.put(op, opDesc);
    }

    @Override
    public void contributeAlgebricksPartitionConstraint(IOperatorDescriptor opDesc, AlgebricksPartitionConstraint apc) {
        this.partitionConstraintMap.put(opDesc, apc);
    }

    @Override
    public JobSpecification getJobSpec() {
        return this.jobSpec;
    }

    @Override
    public void buildSpec(List<ILogicalOperator> roots) throws AlgebricksException {
        this.buildAsterixComponents();
        Map<IConnectorDescriptor, IHyracksJobBuilder.TargetConstraint> tgtConstraints = this.setupConnectors();
        for (ILogicalOperator r : roots) {
            IOperatorDescriptor opDesc = this.findOpDescForAlgebraicOp(r);
            this.jobSpec.addRoot(opDesc);
        }
        this.setAllPartitionConstraints(tgtConstraints);
    }

    private void setAllPartitionConstraints(Map<IConnectorDescriptor, IHyracksJobBuilder.TargetConstraint> tgtConstraints) {
        List roots = this.jobSpec.getRoots();
        this.setSpecifiedPartitionConstraints();
        for (OperatorDescriptorId rootId : roots) {
            this.setPartitionConstraintsDFS(rootId, tgtConstraints, null);
        }
    }

    private void setSpecifiedPartitionConstraints() {
        AlgebricksPartitionConstraint pc;
        for (ILogicalOperator op : this.pcForMicroOps.keySet()) {
            pc = this.pcForMicroOps.get(op);
            Integer k = this.algebraicOpBelongingToMetaAsterixOp.get(op);
            AlgebricksMetaOperatorDescriptor amod = this.metaAsterixOps.get(k);
            this.partitionConstraintMap.put((IOperatorDescriptor)amod, pc);
        }
        for (IOperatorDescriptor opDesc : this.partitionConstraintMap.keySet()) {
            pc = this.partitionConstraintMap.get(opDesc);
            AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)this.jobSpec, (IOperatorDescriptor)opDesc, (AlgebricksPartitionConstraint)pc);
        }
    }

    private void setPartitionConstraintsDFS(OperatorDescriptorId opId, Map<IConnectorDescriptor, IHyracksJobBuilder.TargetConstraint> tgtConstraints, IOperatorDescriptor parentOp) {
        List opInputs = (List)this.jobSpec.getOperatorInputMap().get(opId);
        AlgebricksPartitionConstraint opConstraint = null;
        IOperatorDescriptor opDesc = (IOperatorDescriptor)this.jobSpec.getOperatorMap().get(opId);
        if (opInputs != null) {
            for (IConnectorDescriptor conn : opInputs) {
                ConnectorDescriptorId cid = conn.getConnectorId();
                org.apache.commons.lang3.tuple.Pair p = (org.apache.commons.lang3.tuple.Pair)this.jobSpec.getConnectorOperatorMap().get(cid);
                IOperatorDescriptor src = (IOperatorDescriptor)((org.apache.commons.lang3.tuple.Pair)p.getLeft()).getLeft();
                this.setPartitionConstraintsDFS(src.getOperatorId(), tgtConstraints, opDesc);
                IHyracksJobBuilder.TargetConstraint constraint = tgtConstraints.get(conn);
                if (constraint == null) continue;
                switch (constraint) {
                    case ONE: {
                        opConstraint = new AlgebricksCountPartitionConstraint(1);
                        break;
                    }
                    case SAME_COUNT: {
                        opConstraint = this.partitionConstraintMap.get(src);
                    }
                }
            }
        }
        if (this.partitionConstraintMap.get(opDesc) == null) {
            if (opConstraint == null) {
                if (parentOp != null) {
                    AlgebricksPartitionConstraint pc = this.partitionConstraintMap.get(parentOp);
                    if (pc != null) {
                        opConstraint = pc;
                    } else if (opInputs == null || opInputs.size() == 0) {
                        opConstraint = new AlgebricksCountPartitionConstraint(1);
                    }
                }
                if (opConstraint == null) {
                    opConstraint = this.clusterLocations;
                }
            }
            this.partitionConstraintMap.put(opDesc, opConstraint);
            AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)this.jobSpec, (IOperatorDescriptor)opDesc, (AlgebricksPartitionConstraint)opConstraint);
        }
    }

    private Map<IConnectorDescriptor, IHyracksJobBuilder.TargetConstraint> setupConnectors() throws AlgebricksException {
        HashMap<IConnectorDescriptor, IHyracksJobBuilder.TargetConstraint> tgtConstraints = new HashMap<IConnectorDescriptor, IHyracksJobBuilder.TargetConstraint>();
        for (ILogicalOperator exchg : this.connectors.keySet()) {
            ILogicalOperator inOp = this.inEdges.get(exchg).get(0);
            ILogicalOperator outOp = this.outEdges.get(exchg).get(0);
            IOperatorDescriptor inOpDesc = this.findOpDescForAlgebraicOp(inOp);
            IOperatorDescriptor outOpDesc = this.findOpDescForAlgebraicOp(outOp);
            Pair<IConnectorDescriptor, IHyracksJobBuilder.TargetConstraint> connPair = this.connectors.get(exchg);
            IConnectorDescriptor conn = (IConnectorDescriptor)connPair.first;
            int producerPort = this.outEdges.get(inOp).indexOf(exchg);
            int consumerPort = this.inEdges.get(outOp).indexOf(exchg);
            this.jobSpec.connect(conn, inOpDesc, producerPort, outOpDesc, consumerPort);
            if (connPair.second == null) continue;
            tgtConstraints.put(conn, (IHyracksJobBuilder.TargetConstraint)((Object)connPair.second));
        }
        return tgtConstraints;
    }

    private IOperatorDescriptor findOpDescForAlgebraicOp(ILogicalOperator op) throws AlgebricksException {
        IOperatorDescriptor hOpDesc = this.hyracksOps.get(op);
        if (hOpDesc != null) {
            return hOpDesc;
        }
        Integer metaOpKey = this.algebraicOpBelongingToMetaAsterixOp.get(op);
        if (metaOpKey == null) {
            throw new AlgebricksException("Could not generate operator descriptor for operator " + op);
        }
        return (IOperatorDescriptor)this.metaAsterixOps.get(metaOpKey);
    }

    private void buildAsterixComponents() {
        for (ILogicalOperator aop : this.microOps.keySet()) {
            this.addMicroOpToMetaRuntimeOp(aop);
        }
        for (Integer k : this.metaAsterixOpSkeletons.keySet()) {
            List<Pair<IPushRuntimeFactory, RecordDescriptor>> opContents = this.metaAsterixOpSkeletons.get(k);
            AlgebricksMetaOperatorDescriptor amod = this.buildMetaAsterixOpDesc(opContents);
            this.metaAsterixOps.put(k, amod);
        }
    }

    private AlgebricksMetaOperatorDescriptor buildMetaAsterixOpDesc(List<Pair<IPushRuntimeFactory, RecordDescriptor>> opContents) {
        int n = opContents.size();
        IPushRuntimeFactory[] runtimeFactories = new IPushRuntimeFactory[n];
        RecordDescriptor[] internalRecordDescriptors = new RecordDescriptor[n];
        int i = 0;
        for (Pair<IPushRuntimeFactory, RecordDescriptor> p : opContents) {
            runtimeFactories[i] = (IPushRuntimeFactory)p.first;
            internalRecordDescriptors[i] = (RecordDescriptor)p.second;
            ++i;
        }
        ILogicalOperator lastLogicalOp = this.revMicroOpMap.get(runtimeFactories[n - 1]);
        ArrayList<ILogicalOperator> outOps = this.outEdges.get(lastLogicalOp);
        int outArity = outOps == null ? 0 : outOps.size();
        ILogicalOperator firstLogicalOp = this.revMicroOpMap.get(runtimeFactories[0]);
        ArrayList<ILogicalOperator> inOps = this.inEdges.get(firstLogicalOp);
        int inArity = inOps == null ? 0 : inOps.size();
        return new AlgebricksMetaOperatorDescriptor((IOperatorDescriptorRegistry)this.jobSpec, inArity, outArity, runtimeFactories, internalRecordDescriptors);
    }

    private void addMicroOpToMetaRuntimeOp(ILogicalOperator aop) {
        ArrayList<ILogicalOperator> destList;
        Integer k = this.algebraicOpBelongingToMetaAsterixOp.get(aop);
        if (k == null) {
            k = this.createNewMetaOpInfo(aop);
        }
        if ((destList = this.outEdges.get(aop)) == null || destList.size() != 1) {
            return;
        }
        ILogicalOperator dest = destList.get(0);
        Integer j = this.algebraicOpBelongingToMetaAsterixOp.get(dest);
        if (j == null && this.microOps.get(dest) != null) {
            this.algebraicOpBelongingToMetaAsterixOp.put(dest, k);
            List<Pair<IPushRuntimeFactory, RecordDescriptor>> aodContent1 = this.metaAsterixOpSkeletons.get(k);
            aodContent1.add(this.microOps.get(dest));
        } else if (j != null && j.intValue() != k.intValue()) {
            List<Pair<IPushRuntimeFactory, RecordDescriptor>> aodContent1 = this.metaAsterixOpSkeletons.get(k);
            List<Pair<IPushRuntimeFactory, RecordDescriptor>> aodContent2 = this.metaAsterixOpSkeletons.get(j);
            aodContent1.addAll(aodContent2);
            this.metaAsterixOpSkeletons.remove(j);
            for (ILogicalOperator m : this.algebraicOpBelongingToMetaAsterixOp.keySet()) {
                Integer g = this.algebraicOpBelongingToMetaAsterixOp.get(m);
                if (g.intValue() != j.intValue()) continue;
                this.algebraicOpBelongingToMetaAsterixOp.put(m, k);
            }
        }
    }

    private int createNewMetaOpInfo(ILogicalOperator aop) {
        int n = this.aodCounter++;
        ArrayList<Pair<IPushRuntimeFactory, RecordDescriptor>> metaOpContents = new ArrayList<Pair<IPushRuntimeFactory, RecordDescriptor>>();
        metaOpContents.add(this.microOps.get(aop));
        this.metaAsterixOpSkeletons.put(n, metaOpContents);
        this.algebraicOpBelongingToMetaAsterixOp.put(aop, n);
        return n;
    }

    private <E> void addAtPos(ArrayList<E> a, E elem, int pos) {
        int n = a.size();
        if (n > pos) {
            a.set(pos, elem);
        } else {
            for (int k = n; k < pos; ++k) {
                a.add(null);
            }
            a.add(elem);
        }
    }
}

