/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.core.algebra.util;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import edu.uci.ics.hyracks.algebricks.core.algebra.typing.ITypingContext;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class OperatorManipulationUtil {
    public static void ntsToEts(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() == LogicalOperatorTag.NESTEDTUPLESOURCE) {
            EmptyTupleSourceOperator ets = new EmptyTupleSourceOperator();
            context.computeAndSetTypeEnvironmentForOperator(ets);
            opRef.setValue((Object)ets);
        } else {
            for (Mutable<ILogicalOperator> i : ((ILogicalOperator)opRef.getValue()).getInputs()) {
                OperatorManipulationUtil.ntsToEts(i, context);
            }
        }
    }

    public static ILogicalOperator eliminateSingleSubplanOverEts(SubplanOperator subplan) {
        if (subplan.getNestedPlans().size() > 1) {
            List<Mutable<ILogicalOperator>> subInpList = subplan.getInputs();
            subInpList.clear();
            subInpList.add((Mutable<ILogicalOperator>)new MutableObject((Object)new EmptyTupleSourceOperator()));
            return subplan;
        }
        ILogicalPlan plan = subplan.getNestedPlans().get(0);
        if (plan.getRoots().size() > 1) {
            List<Mutable<ILogicalOperator>> subInpList = subplan.getInputs();
            subInpList.clear();
            subInpList.add((Mutable<ILogicalOperator>)new MutableObject((Object)new EmptyTupleSourceOperator()));
            return subplan;
        }
        return (ILogicalOperator)plan.getRoots().get(0).getValue();
    }

    public static boolean setOperatorMode(AbstractLogicalOperator op) {
        boolean change = false;
        block0 : switch (op.getOperatorTag()) {
            case DATASOURCESCAN: {
                AbstractLogicalOperator child;
                op.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
                AbstractLogicalOperator currentOp = op;
                while (currentOp.getInputs().size() == 1 && (child = (AbstractLogicalOperator)currentOp.getInputs().get(0).getValue()).getOperatorTag() != LogicalOperatorTag.EXCHANGE) {
                    child.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
                    currentOp = child;
                }
                change = true;
                break;
            }
            case NESTEDTUPLESOURCE: {
                NestedTupleSourceOperator nts = (NestedTupleSourceOperator)op;
                AbstractLogicalOperator prevOp = (AbstractLogicalOperator)((ILogicalOperator)nts.getDataSourceReference().getValue()).getInputs().get(0).getValue();
                if (prevOp.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.UNPARTITIONED) break;
                nts.setExecutionMode(AbstractLogicalOperator.ExecutionMode.LOCAL);
                change = true;
                break;
            }
            default: {
                AggregateOperator aggOp;
                LimitOperator opLim;
                boolean forceUnpartitioned = false;
                if (op.getOperatorTag() == LogicalOperatorTag.LIMIT && (opLim = (LimitOperator)op).isTopmostLimitOp()) {
                    opLim.setExecutionMode(AbstractLogicalOperator.ExecutionMode.UNPARTITIONED);
                    change = true;
                    forceUnpartitioned = true;
                }
                if (op.getOperatorTag() == LogicalOperatorTag.AGGREGATE && (aggOp = (AggregateOperator)op).isGlobal()) {
                    op.setExecutionMode(AbstractLogicalOperator.ExecutionMode.UNPARTITIONED);
                    change = true;
                    forceUnpartitioned = true;
                }
                for (Mutable<ILogicalOperator> i : op.getInputs()) {
                    boolean exit = false;
                    AbstractLogicalOperator inputOp = (AbstractLogicalOperator)i.getValue();
                    switch (inputOp.getExecutionMode()) {
                        case PARTITIONED: {
                            if (forceUnpartitioned) break;
                            op.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
                            change = true;
                            exit = true;
                            break;
                        }
                        case LOCAL: {
                            op.setExecutionMode(AbstractLogicalOperator.ExecutionMode.LOCAL);
                            change = true;
                        }
                    }
                    if (!exit) continue;
                    break block0;
                }
            }
        }
        return change;
    }

    public static void substituteVarRec(AbstractLogicalOperator op, LogicalVariable v1, LogicalVariable v2, boolean goThroughNts, ITypingContext ctx) throws AlgebricksException {
        NestedTupleSourceOperator nts;
        VariableUtilities.substituteVariables(op, v1, v2, goThroughNts, ctx);
        for (Mutable<ILogicalOperator> opRef2 : op.getInputs()) {
            OperatorManipulationUtil.substituteVarRec((AbstractLogicalOperator)opRef2.getValue(), v1, v2, goThroughNts, ctx);
        }
        if (op.getOperatorTag() == LogicalOperatorTag.NESTEDTUPLESOURCE && goThroughNts && (nts = (NestedTupleSourceOperator)op).getDataSourceReference() != null) {
            AbstractLogicalOperator op2 = (AbstractLogicalOperator)((ILogicalOperator)nts.getDataSourceReference().getValue()).getInputs().get(0).getValue();
            OperatorManipulationUtil.substituteVarRec(op2, v1, v2, goThroughNts, ctx);
        }
        if (op.hasNestedPlans()) {
            AbstractOperatorWithNestedPlans aonp = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan p : aonp.getNestedPlans()) {
                for (Mutable<ILogicalOperator> ref : p.getRoots()) {
                    AbstractLogicalOperator aop = (AbstractLogicalOperator)ref.getValue();
                    OperatorManipulationUtil.substituteVarRec(aop, v1, v2, goThroughNts, ctx);
                }
            }
        }
    }
}

