/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.core.algebra.typing;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.IExpressionTypeComputer;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.INullableTypeComputer;
import edu.uci.ics.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.TypePropagationPolicy;
import edu.uci.ics.hyracks.algebricks.core.algebra.typing.AbstractTypeEnvironment;
import edu.uci.ics.hyracks.algebricks.core.algebra.typing.ITypeEnvPointer;
import java.util.ArrayList;
import java.util.List;

public class PropagatingTypeEnvironment
extends AbstractTypeEnvironment {
    private final TypePropagationPolicy policy;
    private final INullableTypeComputer nullableTypeComputer;
    private final ITypeEnvPointer[] envPointers;
    private final List<LogicalVariable> nonNullVariables = new ArrayList<LogicalVariable>();

    public PropagatingTypeEnvironment(IExpressionTypeComputer expressionTypeComputer, INullableTypeComputer nullableTypeComputer, IMetadataProvider<?, ?> metadataProvider, TypePropagationPolicy policy, ITypeEnvPointer[] envPointers) {
        super(expressionTypeComputer, metadataProvider);
        this.nullableTypeComputer = nullableTypeComputer;
        this.policy = policy;
        this.envPointers = envPointers;
    }

    @Override
    public Object getVarType(LogicalVariable var) throws AlgebricksException {
        return this.getVarTypeFullList(var, this.nonNullVariables);
    }

    public List<LogicalVariable> getNonNullVariables() {
        return this.nonNullVariables;
    }

    @Override
    public Object getVarType(LogicalVariable var, List<LogicalVariable> nonNullVariableList) throws AlgebricksException {
        nonNullVariableList.addAll(this.nonNullVariables);
        return this.getVarTypeFullList(var, nonNullVariableList);
    }

    private Object getVarTypeFullList(LogicalVariable var, List<LogicalVariable> nonNullVariableList) throws AlgebricksException {
        Object t = this.varTypeMap.get(var);
        if (t != null) {
            return t;
        }
        return this.policy.getVarType(var, this.nullableTypeComputer, nonNullVariableList, this.envPointers);
    }
}

