/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.core.algebra.typing;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.IExpressionTypeComputer;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import edu.uci.ics.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractTypeEnvironment
implements IVariableTypeEnvironment {
    protected final Map<LogicalVariable, Object> varTypeMap = new HashMap<LogicalVariable, Object>();
    protected final IExpressionTypeComputer expressionTypeComputer;
    protected final IMetadataProvider<?, ?> metadataProvider;

    public AbstractTypeEnvironment(IExpressionTypeComputer expressionTypeComputer, IMetadataProvider<?, ?> metadataProvider) {
        this.expressionTypeComputer = expressionTypeComputer;
        this.metadataProvider = metadataProvider;
    }

    @Override
    public Object getType(ILogicalExpression expr) throws AlgebricksException {
        return this.expressionTypeComputer.getType(expr, this.metadataProvider, this);
    }

    @Override
    public void setVarType(LogicalVariable var, Object type) {
        this.varTypeMap.put(var, type);
    }

    @Override
    public boolean substituteProducedVariable(LogicalVariable v1, LogicalVariable v2) throws AlgebricksException {
        Object t = this.varTypeMap.get(v1);
        if (t == null) {
            return false;
        }
        this.varTypeMap.put(v1, null);
        this.varTypeMap.put(v2, t);
        return true;
    }
}

