/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.core.algebra.properties;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;

public abstract class VariablePropagationPolicy {
    public static final VariablePropagationPolicy ALL = new VariablePropagationPolicy(){

        @Override
        public void propagateVariables(IOperatorSchema target, IOperatorSchema ... sources) {
            int n = sources.length;
            for (int i = 0; i < n; ++i) {
                target.addAllNewVariables(sources[i]);
            }
        }
    };
    public static final VariablePropagationPolicy NONE = new VariablePropagationPolicy(){

        @Override
        public void propagateVariables(IOperatorSchema target, IOperatorSchema ... sources) {
        }
    };
    public static final VariablePropagationPolicy ADDNEWVARIABLES = new VariablePropagationPolicy(){

        @Override
        public void propagateVariables(IOperatorSchema target, IOperatorSchema ... sources) {
            for (IOperatorSchema s : sources) {
                for (LogicalVariable v : s) {
                    if (target.findVariable(v) >= 0) continue;
                    target.addVariable(v);
                }
            }
        }
    };

    public abstract void propagateVariables(IOperatorSchema var1, IOperatorSchema ... var2) throws AlgebricksException;

    public static VariablePropagationPolicy concat(final VariablePropagationPolicy ... policies) {
        return new VariablePropagationPolicy(){

            @Override
            public void propagateVariables(IOperatorSchema target, IOperatorSchema ... sources) throws AlgebricksException {
                if (policies.length != sources.length) {
                    throw new IllegalArgumentException();
                }
                for (int i = 0; i < policies.length; ++i) {
                    VariablePropagationPolicy p = policies[i];
                    IOperatorSchema s = sources[i];
                    p.propagateVariables(target, s);
                }
            }
        };
    }
}

